/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.util.concurrent.Callable;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.XmlOut;

public class DumpXmlTask
implements Callable<Void> {
    private static final String ERR_IO = "\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    private static final String ERR_ABORT = "XML\u51fa\u529b\u304c\u4e2d\u65ad\u3055\u308c\u307e\u3057\u305f";
    private final VillageData villageData;
    private final XmlOut writer;

    public DumpXmlTask(VillageData villageData, XmlOut writer) {
        this.villageData = villageData;
        this.writer = writer;
    }

    public static String getErrDescription(Throwable cause) {
        String desc = cause instanceof IOException ? ERR_IO : ERR_ABORT;
        return desc;
    }

    @Override
    public Void call() throws IOException {
        try {
            this.writer.dumpVillageData(this.villageData);
        }
        finally {
            this.writer.close();
        }
        return null;
    }
}

