/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.LandDef;
import org.xml.sax.SAXException;

public final class LandUtils {
    private static final List<LandDef> LANDDEF_LIST;
    private static final char DELIM_SP = ' ';

    private LandUtils() {
        assert (false);
        throw new AssertionError();
    }

    public static LandDef getLandDef(String landId) {
        for (LandDef landDef : LANDDEF_LIST) {
            String id = landDef.getLandId();
            if (!id.equals(landId)) continue;
            return landDef;
        }
        return null;
    }

    public static String getLandIdCatalog() {
        StringBuilder catalog = new StringBuilder();
        for (LandDef landDef : LANDDEF_LIST) {
            if (catalog.length() > 0) {
                catalog.append(' ');
            }
            String id = landDef.getLandId();
            catalog.append(id);
        }
        String result = catalog.toString();
        return result;
    }

    static {
        DocumentBuilder builder;
        try {
            builder = XmlUtils.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            LANDDEF_LIST = LandDef.buildLandDefList(builder);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

