/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.corelib;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DateUtils {
    private static final Pattern ISO8601_PATTERN;
    private static final String REG_PLUS = "\\+";
    private static final String REG_HYPHEN = "\\-";

    private DateUtils() {
        assert (false);
    }

    public static long parseISO8601(CharSequence date) throws IllegalArgumentException {
        Matcher matcher = ISO8601_PATTERN.matcher(date);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(date.toString());
        }
        int gid = 1;
        String yearStr = matcher.group(gid++);
        String monthStr = matcher.group(gid++);
        String dayStr = matcher.group(gid++);
        String hourStr = matcher.group(gid++);
        String minuteStr = matcher.group(gid++);
        String secondStr = matcher.group(gid++);
        String tzString = matcher.group(gid++);
        int year = Integer.parseInt(yearStr);
        int month = Integer.parseInt(monthStr);
        int day = Integer.parseInt(dayStr);
        int hour = Integer.parseInt(hourStr);
        int minute = Integer.parseInt(minuteStr);
        int second = Integer.parseInt(secondStr);
        String tzID = tzString.compareToIgnoreCase("Z") == 0 ? "GMT+00:00" : "GMT" + tzString;
        TimeZone timezone = TimeZone.getTimeZone(tzID);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        ((Calendar)calendar).setTimeZone(timezone);
        calendar.set(year, month - 1, day, hour, minute, second);
        long result = calendar.getTimeInMillis();
        return result;
    }

    static {
        StringBuilder txt = new StringBuilder();
        String gYear = "([0-9][0-9][0-9][0-9])";
        String gMonth = "([0-1][0-9])";
        String gDay = "([0-3][0-9])";
        txt.append(gYear).append(REG_HYPHEN);
        txt.append(gMonth).append(REG_HYPHEN);
        txt.append(gDay);
        txt.append('T');
        String gHour = "([0-2][0-9])";
        String gMinute = "([0-5][0-9])";
        String gSecond = "([0-6][0-9])";
        txt.append(gHour).append(':');
        txt.append(gMinute).append(':');
        txt.append(gSecond);
        String diffHour = "[\\+\\-][0-2][0-9]";
        String diffMin = "(?::?[0-5][0-9])?";
        String gTimezone = "(" + diffHour + diffMin + "|Z)";
        txt.append(gTimezone);
        String iso8601Regex = txt.toString();
        ISO8601_PATTERN = Pattern.compile(iso8601Regex);
    }
}

