/*
 * Decompiled with CFR 0.152.
 */
package io.github.olyutorskii.quetexj;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Objects;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class HeightKeeper {
    public static final int DEF_HEIGHTLIMIT = 3000;
    public static final int DEF_NEWHEIGHT = 2500;
    private static final Rectangle DMY_RECT = new Rectangle();
    private final JTextArea textComp;
    private final BoundedRangeModel rangeModel;
    private int heightLimit;
    private int newHeight;
    private final Object condLock = new Object();
    private final SizeWatcher watcher = new SizeWatcher();

    public HeightKeeper(JTextArea textComp, BoundedRangeModel rangeModel) {
        this(textComp, rangeModel, 3000, 2500);
    }

    public HeightKeeper(JTextArea textComp, BoundedRangeModel rangeModel, int heightLimit, int newHeight) {
        Objects.requireNonNull(rangeModel);
        if (newHeight <= 0) {
            throw new IllegalArgumentException();
        }
        if (heightLimit <= newHeight) {
            throw new IllegalArgumentException();
        }
        this.textComp = textComp;
        this.textComp.addComponentListener(this.watcher);
        this.heightLimit = heightLimit;
        this.newHeight = newHeight;
        this.rangeModel = rangeModel;
    }

    public JTextComponent getTextComponent() {
        return this.textComp;
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.rangeModel;
    }

    public int getHeightLimit() {
        return this.heightLimit;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConditions(int heightLimitArg, int newHeightArg) throws IllegalArgumentException {
        if (newHeightArg <= 0) {
            throw new IllegalArgumentException();
        }
        if (heightLimitArg <= newHeightArg) {
            throw new IllegalArgumentException();
        }
        Object object = this.condLock;
        synchronized (object) {
            this.heightLimit = heightLimitArg;
            this.newHeight = newHeightArg;
        }
        if (EventQueue.isDispatchThread()) {
            this.eventResized();
        } else {
            EventQueue.invokeLater(() -> this.eventResized());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eventResized() {
        int condNewHeight;
        int condHeightLimit;
        Object object = this.condLock;
        synchronized (object) {
            condHeightLimit = this.heightLimit;
            condNewHeight = this.newHeight;
        }
        int compHeight = this.textComp.getHeight();
        if (compHeight < condHeightLimit) {
            return;
        }
        int chopHeight = compHeight - condNewHeight;
        int oldRangeVal = this.rangeModel.getValue();
        this.chopHeadHeightRowBounds(chopHeight);
        this.adjustBoundedRangeModel(chopHeight, oldRangeVal);
    }

    private void chopHeadHeightRowBounds(int chopRegionHeight) {
        int docLastPos = this.chopHeightToLinedOffset(chopRegionHeight);
        this.chopHeadHeightByDocPos(docLastPos);
    }

    private int chopHeightToLinedOffset(int chopHeight) {
        int chopWidth = this.textComp.getWidth();
        Point edgePoint = new Point(chopWidth - 1, chopHeight - 1);
        int docOffset = this.textComp.viewToModel(edgePoint);
        return docOffset;
    }

    private void chopHeadHeightByDocPos(int docLastPos) {
        block4: {
            if (docLastPos < 0) {
                return;
            }
            Document document = this.textComp.getDocument();
            int docLength = document.getLength();
            if (docLength <= 0) {
                return;
            }
            int regionLength = Integer.min(docLastPos + 1, docLength);
            try {
                document.remove(0, regionLength);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    private int adjustBoundedRangeModel(int chopHeight, int oldRangeVal) {
        int realChopHeight = this.getRealChopHeight(chopHeight);
        int newRangeVal = oldRangeVal - realChopHeight;
        this.rangeModel.setValue(newRangeVal);
        return newRangeVal;
    }

    private int getRealChopHeight(int chopHeight) {
        int insetsTop = this.textComp.getInsets().top;
        int bodyHeight = chopHeight - insetsTop;
        int rowHeight = this.getRowHeight();
        int chopRows = bodyHeight / rowHeight + 1;
        int realChopHeight = rowHeight * chopRows + insetsTop;
        return realChopHeight;
    }

    private int getRowHeight() {
        int result = this.textComp.getScrollableUnitIncrement(DMY_RECT, 1, 0);
        return result;
    }

    private class SizeWatcher
    extends ComponentAdapter {
        SizeWatcher() {
        }

        @Override
        public void componentResized(ComponentEvent ev) {
            HeightKeeper.this.eventResized();
        }
    }
}

