/*
 * Decompiled with CFR 0.152.
 */
package io.github.olyutorskii.quetexj;

import java.awt.EventQueue;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;

public class MaxTracker {
    private static final int VAL_INVALID = -1;
    private final BoundedRangeModel rangeModel;
    private final ButtonModel trackModeModel;
    private int trackStartPos;

    public MaxTracker(BoundedRangeModel rangeModel) {
        this(rangeModel, new DefaultButtonModel());
    }

    public MaxTracker(BoundedRangeModel rangeModel, ButtonModel trackModeModel) {
        this.rangeModel = rangeModel;
        this.trackModeModel = trackModeModel;
        this.rangeModel.addChangeListener(ev -> this.eventBoundedRangeChanged());
        this.trackModeModel.addItemListener(ev -> this.eventTrackModeChanged());
        this.resetTrackStartPos();
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.rangeModel;
    }

    public ButtonModel getButtonModel() {
        return this.trackModeModel;
    }

    public boolean isTrackingMode() {
        boolean result = this.trackModeModel.isSelected();
        return result;
    }

    public void setTrackingMode(boolean tracking) {
        if (EventQueue.isDispatchThread()) {
            this.setTrackingModeImpl(tracking);
        } else {
            EventQueue.invokeLater(() -> this.setTrackingModeImpl(tracking));
        }
    }

    private void setTrackingModeImpl(boolean tracking) {
        boolean oldCond = this.isTrackingMode();
        if (tracking == oldCond) {
            return;
        }
        this.trackModeModel.setSelected(tracking);
    }

    private boolean isHandAdjusting() {
        boolean result = this.rangeModel.getValueIsAdjusting();
        return result;
    }

    private boolean isKnobTouchMax() {
        int val = this.rangeModel.getValue();
        int max = this.rangeModel.getMaximum();
        int extent = this.rangeModel.getExtent();
        boolean touchMax = val + extent >= max;
        return touchMax;
    }

    private void setTrackStartPos() {
        this.trackStartPos = this.rangeModel.getValue();
    }

    private void resetTrackStartPos() {
        this.trackStartPos = -1;
    }

    private boolean keepingTrackStartPos() {
        int modelVal = this.rangeModel.getValue();
        boolean result = this.trackStartPos == modelVal;
        return result;
    }

    private void forceKnobTouchMax() {
        if (this.isKnobTouchMax()) {
            return;
        }
        if (this.isHandAdjusting()) {
            return;
        }
        int max = this.rangeModel.getMaximum();
        int extent = this.rangeModel.getExtent();
        int newVal = max - extent;
        this.rangeModel.setValue(newVal);
    }

    private void checkTrackingByKnob() {
        boolean knobTouchMax = this.isKnobTouchMax();
        if (knobTouchMax) {
            this.setTrackingMode(true);
            this.setTrackStartPos();
        } else if (!this.keepingTrackStartPos()) {
            this.setTrackingMode(false);
        }
    }

    private void eventBoundedRangeChanged() {
        if (this.isHandAdjusting()) {
            this.checkTrackingByKnob();
            return;
        }
        this.resetTrackStartPos();
        if (this.isTrackingMode()) {
            this.forceKnobTouchMax();
        }
    }

    private void eventTrackModeChanged() {
        if (this.isTrackingMode()) {
            this.forceKnobTouchMax();
        }
    }
}

