/*
 * Decompiled with CFR 0.152.
 */
package io.github.olyutorskii.quetexj;

import io.github.olyutorskii.quetexj.ClearDocumentAction;
import io.github.olyutorskii.quetexj.HeightKeeper;
import io.github.olyutorskii.quetexj.MaxTracker;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MvcFacade {
    private final Document document;
    private final BoundedRangeModel vertRangeModel;
    private final JToggleButton.ToggleButtonModel trackSwitchButtonModel;
    private final JTextArea textArea;
    private final HeightKeeper heightKeeper;
    private final MaxTracker maxTracker;
    private final Action clearAction;

    public MvcFacade() {
        this(new PlainDocument(), new DefaultBoundedRangeModel(), new JToggleButton.ToggleButtonModel());
    }

    public MvcFacade(Document document, BoundedRangeModel vertRangeModel, JToggleButton.ToggleButtonModel trackSwitchButtonModel) {
        this.document = document;
        this.vertRangeModel = vertRangeModel;
        this.trackSwitchButtonModel = trackSwitchButtonModel;
        this.textArea = MvcFacade.buildTextArea(this.document);
        this.heightKeeper = new HeightKeeper(this.textArea, this.vertRangeModel);
        this.maxTracker = new MaxTracker(this.vertRangeModel, this.trackSwitchButtonModel);
        this.clearAction = new ClearDocumentAction(this.document);
    }

    private static JTextArea buildTextArea(Document doc) {
        JTextArea textComp = new JTextArea();
        textComp.setEditable(false);
        textComp.setLineWrap(true);
        DefaultCaret caret = new DefaultCaret();
        caret.setUpdatePolicy(1);
        textComp.setCaret(caret);
        textComp.setDocument(doc);
        return textComp;
    }

    public Document getDocument() {
        return this.document;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public BoundedRangeModel getVerticalBoundedRangeModel() {
        return this.vertRangeModel;
    }

    public HeightKeeper getHeightKeeper() {
        return this.heightKeeper;
    }

    public MaxTracker getMaxTracker() {
        return this.maxTracker;
    }

    public JToggleButton.ToggleButtonModel getTrackSwitchButtonModel() {
        return this.trackSwitchButtonModel;
    }

    public Action getClearAction() {
        return this.clearAction;
    }
}

