/*
 * Decompiled with CFR 0.152.
 */
package io.github.olyutorskii.quetexj;

import java.awt.EventQueue;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SwingLogHandler
extends Handler {
    private final Document document;
    private final Queue<String> msgQueue;
    private final LogTransferTask transferTask;

    public SwingLogHandler() {
        this(new PlainDocument());
    }

    public SwingLogHandler(Document document) {
        Objects.requireNonNull(document);
        this.document = document;
        this.msgQueue = new ConcurrentLinkedQueue<String>();
        this.transferTask = new LogTransferTask(this.msgQueue);
        SimpleFormatter formatter = new SimpleFormatter();
        this.setFormatter(formatter);
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        Formatter formatter = this.getFormatter();
        String message = formatter.format(record);
        this.publish(message);
    }

    private void publish(String message) {
        boolean offered = this.msgQueue.offer(message);
        assert (offered);
        if (EventQueue.isDispatchThread()) {
            this.transferTask.transferQueueToDoc();
        } else {
            EventQueue.invokeLater(this.transferTask);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.setLevel(Level.OFF);
        this.flush();
    }

    private class LogTransferTask
    implements Runnable {
        private final Queue<String> queue;
        private final StringBuilder msgBuf;

        LogTransferTask(Queue<String> queue) {
            this.queue = queue;
            this.msgBuf = new StringBuilder();
        }

        @Override
        public void run() {
            this.transferQueueToDoc();
        }

        void transferQueueToDoc() {
            String msg;
            int queueSize = this.queue.size();
            if (queueSize == 1) {
                String msg2 = this.queue.poll();
                this.appendToDocument(msg2);
                return;
            }
            if (queueSize <= 0) {
                return;
            }
            this.msgBuf.setLength(0);
            while (!this.queue.isEmpty() && (msg = this.queue.poll()) != null) {
                this.msgBuf.append(msg);
            }
            this.appendToDocument(this.msgBuf);
        }

        private void appendToDocument(CharSequence logMessage) {
            block4: {
                if (logMessage == null) {
                    return;
                }
                if (logMessage.length() <= 0) {
                    return;
                }
                Document doc = SwingLogHandler.this.getDocument();
                String str = logMessage.toString();
                int insertPt = doc.getLength();
                try {
                    doc.insertString(insertPt, str, null);
                }
                catch (BadLocationException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
    }
}

