/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.jindolf.parser;

import java.util.regex.MatchResult;

public class SeqRange {
    private int startPos;
    private int endPos;

    public SeqRange() {
        this(-1, -1);
    }

    public SeqRange(int startPos, int endPos) {
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    public void setEndPos(int endPos) {
        this.endPos = endPos;
    }

    public void setRange(int startPosition, int endPosition) {
        this.startPos = startPosition;
        this.endPos = endPosition;
    }

    public void setLastMatchedGroupRange(MatchResult result, int groupId) throws IllegalStateException, IndexOutOfBoundsException {
        this.startPos = result.start(groupId);
        this.endPos = result.end(groupId);
    }

    public void setLastMatchedRange(MatchResult result) throws IllegalStateException {
        this.startPos = result.start();
        this.endPos = result.end();
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public int length() {
        int length = this.endPos - this.startPos;
        return length;
    }

    public CharSequence sliceSequence(CharSequence seq) throws IndexOutOfBoundsException {
        CharSequence result = seq.subSequence(this.startPos, this.endPos);
        return result;
    }

    public void setInvalid() {
        this.startPos = -1;
        this.endPos = -1;
    }

    public boolean isValid() {
        if (this.startPos < 0) {
            return false;
        }
        return this.startPos <= this.endPos;
    }
}

