/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sfjp.jindolf.view.TopFrame;
import jp.sfjp.jindolf.view.TopView;

public class BusyStatus {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final TopFrame topFrame;
    private final Executor executor = Executors.newCachedThreadPool();
    private boolean isBusy = false;

    public BusyStatus(TopFrame topFrame) {
        this.topFrame = topFrame;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void setBusy(boolean flag, String msg) {
        if (EventQueue.isDispatchThread()) {
            this.setBusyEdt(flag, msg);
            return;
        }
        try {
            EventQueue.invokeAndWait(() -> this.setBusyEdt(flag, msg));
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "\u30d3\u30b8\u30fc\u51e6\u7406\u3067\u5931\u6557", e);
        }
    }

    public void setBusyEdt(boolean flag, String msg) {
        assert (EventQueue.isDispatchThread());
        this.isBusy = flag;
        this.topFrame.setBusy(this.isBusy);
        if (msg != null) {
            TopView topView = this.topFrame.getTopView();
            topView.updateSysMessage(msg);
        }
    }

    public void submitLightBusyTask(Runnable task, String beforeMsg, String afterMsg) {
        EventQueue.invokeLater(() -> this.setBusy(true, beforeMsg));
        EventQueue.invokeLater(task);
        EventQueue.invokeLater(() -> this.setBusy(false, afterMsg));
    }

    public void submitHeavyBusyTask(Runnable heavyTask, String beforeMsg, String afterMsg) {
        this.setBusy(true, beforeMsg);
        EventQueue.invokeLater(() -> this.fork(() -> {
            try {
                heavyTask.run();
            }
            finally {
                this.setBusy(false, afterMsg);
            }
        }));
    }

    private void fork(Runnable task) {
        this.executor.execute(task);
    }
}

