/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreePath;
import jp.sfjp.jindolf.BusyStatus;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.config.AppSetting;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.JsonIo;
import jp.sfjp.jindolf.config.OptionInfo;
import jp.sfjp.jindolf.data.Anchor;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.LandsTreeModel;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.RegexPattern;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.data.html.PeriodLoader;
import jp.sfjp.jindolf.data.html.VillageInfoLoader;
import jp.sfjp.jindolf.data.html.VillageListLoader;
import jp.sfjp.jindolf.data.xml.VillageLoader;
import jp.sfjp.jindolf.dxchg.CsvExporter;
import jp.sfjp.jindolf.dxchg.WebIPCDialog;
import jp.sfjp.jindolf.dxchg.WolfBBS;
import jp.sfjp.jindolf.glyph.AnchorHitEvent;
import jp.sfjp.jindolf.glyph.AnchorHitListener;
import jp.sfjp.jindolf.glyph.Discussion;
import jp.sfjp.jindolf.glyph.FontChooser;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.TalkDraw;
import jp.sfjp.jindolf.log.LogFrame;
import jp.sfjp.jindolf.log.LogUtils;
import jp.sfjp.jindolf.net.ProxyInfo;
import jp.sfjp.jindolf.net.ServerAccess;
import jp.sfjp.jindolf.summary.DaySummary;
import jp.sfjp.jindolf.summary.VillageDigest;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.util.StringUtils;
import jp.sfjp.jindolf.view.ActionManager;
import jp.sfjp.jindolf.view.AvatarPics;
import jp.sfjp.jindolf.view.FilterPanel;
import jp.sfjp.jindolf.view.FindPanel;
import jp.sfjp.jindolf.view.HelpFrame;
import jp.sfjp.jindolf.view.LandsTree;
import jp.sfjp.jindolf.view.OptionPanel;
import jp.sfjp.jindolf.view.PeriodView;
import jp.sfjp.jindolf.view.TabBrowser;
import jp.sfjp.jindolf.view.TopFrame;
import jp.sfjp.jindolf.view.TopView;
import jp.sfjp.jindolf.view.WindowManager;
import jp.sourceforge.jindolf.corelib.VillageState;
import jp.sourceforge.jovsonz.JsObject;
import org.xml.sax.SAXException;

public class Controller
implements ActionListener,
AnchorHitListener {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final String ERRTITLE_LAF = "Look&Feel";
    private static final String ERRFORM_LAFGEN = "\u3053\u306eLook&Feel[{0}]\u3092\u751f\u6210\u3059\u308b\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
    private final LandsTreeModel model;
    private final WindowManager windowManager;
    private final ActionManager actionManager;
    private final AppSetting appSetting;
    private final TopView topView;
    private final JFileChooser xmlFileChooser = Controller.buildFileChooser();
    private final VillageTreeWatcher treeVillageWatcher = new VillageTreeWatcher();
    private final ChangeListener tabPeriodWatcher = new TabPeriodWatcher();
    private final ChangeListener filterWatcher = new FilterWatcher();
    private final BusyStatus busyStatus;

    public Controller(LandsTreeModel model, WindowManager windowManager, ActionManager actionManager, AppSetting setting) {
        this.appSetting = setting;
        this.actionManager = actionManager;
        this.windowManager = windowManager;
        this.model = model;
        this.topView = this.windowManager.getTopFrame().getTopView();
        JToolBar toolbar = this.actionManager.getBrowseToolBar();
        this.topView.setBrowseToolBar(toolbar);
        this.actionManager.addActionListener(this);
        JTree treeView = this.topView.getTreeView();
        treeView.setModel(this.model);
        treeView.addTreeWillExpandListener(this.treeVillageWatcher);
        treeView.addTreeSelectionListener(this.treeVillageWatcher);
        TabBrowser periodTab = this.topView.getTabBrowser();
        periodTab.addChangeListener(this.tabPeriodWatcher);
        periodTab.addActionListener(this);
        periodTab.addAnchorHitListener(this);
        JButton reloadVillageListButton = this.topView.getLandsTree().getReloadVillageListButton();
        reloadVillageListButton.addActionListener(this);
        reloadVillageListButton.setEnabled(false);
        TopFrame topFrame = this.windowManager.getTopFrame();
        OptionPanel optionPanel = this.windowManager.getOptionPanel();
        FindPanel findPanel = this.windowManager.getFindPanel();
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        LogFrame logFrame = this.windowManager.getLogFrame();
        HelpFrame helpFrame = this.windowManager.getHelpFrame();
        topFrame.setJMenuBar(this.actionManager.getMenuBar());
        this.setFrameTitle(null);
        topFrame.setDefaultCloseOperation(2);
        topFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                Controller.this.shutdown();
            }
        });
        this.busyStatus = new BusyStatus(topFrame);
        filterPanel.addChangeListener(this.filterWatcher);
        Handler newHandler = logFrame.getHandler();
        EventQueue.invokeLater(() -> LogUtils.switchHandler(newHandler));
        JsonIo jsonIo = this.appSetting.getJsonIo();
        JsObject history = jsonIo.loadHistoryConfig();
        findPanel.putJson(history);
        FontInfo fontInfo = this.appSetting.getFontInfo();
        periodTab.setFontInfo(fontInfo);
        optionPanel.getFontChooser().setFontInfo(fontInfo);
        ProxyInfo proxyInfo = this.appSetting.getProxyInfo();
        optionPanel.getProxyChooser().setProxyInfo(proxyInfo);
        DialogPref pref = this.appSetting.getDialogPref();
        periodTab.setDialogPref(pref);
        optionPanel.getDialogPrefPanel().setDialogPref(pref);
        OptionInfo optInfo = this.appSetting.getOptionInfo();
        ConfigStore configStore = this.appSetting.getConfigStore();
        helpFrame.updateVmInfo(optInfo, configStore);
    }

    private static void toggleWindow(Window window) {
        if (window == null) {
            return;
        }
        if (window instanceof Frame) {
            boolean isIconified;
            Frame frame = (Frame)window;
            int winState = frame.getExtendedState();
            boolean bl = isIconified = (winState & 1) != 0;
            if (isIconified) {
                frame.setExtendedState(winState &= 0xFFFFFFFE);
                frame.setVisible(true);
                return;
            }
        }
        if (window.isVisible()) {
            window.setVisible(false);
            window.dispose();
        } else {
            window.setVisible(true);
        }
    }

    private static JFileChooser buildFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML files (*.xml)", "xml", "XML");
        chooser.setFileFilter(filter);
        chooser.setDialogTitle("\u30a2\u30fc\u30ab\u30a4\u30d6XML\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f");
        return chooser;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public TopFrame getTopFrame() {
        TopFrame result = this.windowManager.getTopFrame();
        return result;
    }

    private void setFrameTitle(String name) {
        String title = VerInfo.getFrameTitle(name);
        TopFrame topFrame = this.windowManager.getTopFrame();
        topFrame.setTitle(title);
    }

    private PeriodView currentPeriodView() {
        TabBrowser tb = this.topView.getTabBrowser();
        PeriodView result = tb.currentPeriodView();
        return result;
    }

    private Discussion currentDiscussion() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return null;
        }
        Discussion result = periodView.getDiscussion();
        return result;
    }

    private Village getVillage() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        return village;
    }

    private void updateStatusBar(String message) {
        this.topView.updateSysMessage(message);
    }

    private void actionAbout() {
        String message = VerInfo.getAboutMessage();
        JOptionPane pane = new JOptionPane(message, 1, -1, GUIUtils.getLogoIcon());
        JDialog dialog = pane.createDialog(VerInfo.TITLE + "\u306b\u3064\u3044\u3066");
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void actionExit() {
        this.shutdown();
    }

    private void actionHelp() {
        HelpFrame helpFrame = this.windowManager.getHelpFrame();
        Controller.toggleWindow(helpFrame);
    }

    private void actionShowWebVillage() {
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getVillageURL(village);
        String urlText = url.toString();
        if (village.getState() != VillageState.GAMEOVER) {
            urlText = urlText + "#bottom";
        }
        WebIPCDialog.showDialog(this.getTopFrame(), urlText);
    }

    private void actionShowWebWiki() {
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        String urlTxt = WolfBBS.getCastGeneratorUrl(village);
        WebIPCDialog.showDialog(this.getTopFrame(), urlTxt);
    }

    private void actionShowWebDay() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getPeriodURL(period);
        String urlText = url.toString();
        WebIPCDialog.showDialog(this.getTopFrame(), urlText);
    }

    private void actionShowWebTalk() {
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        Talk talk = discussion.getActiveTalk();
        if (talk == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getPeriodURL(period);
        String urlText = url.toString();
        urlText = urlText + "#" + talk.getMessageID();
        WebIPCDialog.showDialog(this.getTopFrame(), urlText);
    }

    private void actionShowPortal() {
        WebIPCDialog.showDialog(this.getTopFrame(), VerInfo.CONTACT);
    }

    private void warnDialog(String title, String message, Throwable e) {
        LOGGER.log(Level.WARNING, message, e);
        JOptionPane.showMessageDialog(this.getTopFrame(), message, VerInfo.getFrameTitle(title), 2);
    }

    private void actionChangeLaF() {
        String className = this.actionManager.getSelectedLookAndFeel();
        if (className == null) {
            return;
        }
        this.busyStatus.submitLightBusyTask(() -> this.taskChangeLaF(className), "Look&Feel\u3092\u66f4\u65b0\u4e2d\u2026", "Look&Feel\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f");
    }

    private void taskChangeLaF(String className) {
        assert (EventQueue.isDispatchThread());
        try {
            this.windowManager.changeAllWindowUI(className);
        }
        catch (UnsupportedLookAndFeelException e) {
            String warnMsg = MessageFormat.format("\u3053\u306eLook&Feel[{0}]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", className);
            this.warnDialog(ERRTITLE_LAF, warnMsg, e);
            return;
        }
        catch (ReflectiveOperationException e) {
            String warnMsg = MessageFormat.format(ERRFORM_LAFGEN, className);
            this.warnDialog(ERRTITLE_LAF, warnMsg, e);
            return;
        }
        this.xmlFileChooser.updateUI();
        LOGGER.log(Level.INFO, "Look&Feel\u304c[{0}]\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002", className);
    }

    private void actionShowFilter() {
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        Controller.toggleWindow(filterPanel);
    }

    private void actionShowLog() {
        LogFrame logFrame = this.windowManager.getLogFrame();
        Controller.toggleWindow(logFrame);
    }

    private void actionOption() {
        OptionPanel optionPanel = this.windowManager.getOptionPanel();
        FontInfo fontInfo = this.appSetting.getFontInfo();
        optionPanel.getFontChooser().setFontInfo(fontInfo);
        ProxyInfo proxyInfo = this.appSetting.getProxyInfo();
        optionPanel.getProxyChooser().setProxyInfo(proxyInfo);
        DialogPref dialogPref = this.appSetting.getDialogPref();
        optionPanel.getDialogPrefPanel().setDialogPref(dialogPref);
        optionPanel.setVisible(true);
        if (optionPanel.isCanceled()) {
            return;
        }
        fontInfo = optionPanel.getFontChooser().getFontInfo();
        this.updateFontInfo(fontInfo);
        proxyInfo = optionPanel.getProxyChooser().getProxyInfo();
        this.updateProxyInfo(proxyInfo);
        dialogPref = optionPanel.getDialogPrefPanel().getDialogPref();
        this.updateDialogPref(dialogPref);
    }

    private void updateFontInfo(FontInfo newFontInfo) {
        FontInfo oldInfo = this.appSetting.getFontInfo();
        if (newFontInfo.equals(oldInfo)) {
            return;
        }
        this.appSetting.setFontInfo(newFontInfo);
        this.topView.getTabBrowser().setFontInfo(newFontInfo);
        OptionPanel optionPanel = this.windowManager.getOptionPanel();
        FontChooser fontChooser = optionPanel.getFontChooser();
        fontChooser.setFontInfo(newFontInfo);
    }

    private void updateProxyInfo(ProxyInfo newProxyInfo) {
        ProxyInfo oldProxyInfo = this.appSetting.getProxyInfo();
        if (newProxyInfo.equals(oldProxyInfo)) {
            return;
        }
        this.appSetting.setProxyInfo(newProxyInfo);
        for (Land land : this.model.getLandList()) {
            ServerAccess server = land.getServerAccess();
            server.setProxy(newProxyInfo.getProxy());
        }
    }

    private void updateDialogPref(DialogPref newDialogPref) {
        DialogPref oldDialogPref = this.appSetting.getDialogPref();
        if (newDialogPref.equals(oldDialogPref)) {
            return;
        }
        this.appSetting.setDialogPref(newDialogPref);
        this.topView.getTabBrowser().setDialogPref(newDialogPref);
    }

    private void actionShowDigest() {
        VillageDigest villageDigest;
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        VillageState villageState = village.getState();
        if (villageState != VillageState.EPILOGUE && villageState != VillageState.GAMEOVER || !village.isValid()) {
            String message = "\u30a8\u30d4\u30ed\u30fc\u30b0\u3092\u6b63\u5e38\u306b\u8fce\u3048\u3066\u3044\u306a\u3044\u6751\u306f\n\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u6a5f\u80fd\u3092\u5229\u7528\u3067\u304d\u307e\u305b\u3093";
            String title = VerInfo.getFrameTitle("\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u4e0d\u53ef");
            JOptionPane pane = new JOptionPane(message, 2, -1);
            JDialog dialog = pane.createDialog(title);
            dialog.pack();
            dialog.setVisible(true);
            dialog.dispose();
            return;
        }
        VillageDigest digest = villageDigest = this.windowManager.getVillageDigest();
        Runnable task = () -> {
            this.taskFullOpenAllPeriod();
            EventQueue.invokeLater(() -> {
                digest.setVillage(village);
                digest.setVisible(true);
            });
        };
        this.busyStatus.submitHeavyBusyTask(task, "\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb", "\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
    }

    private void taskFullOpenAllPeriod() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        for (PeriodView periodView : browser.getPeriodViewList()) {
            Period period = periodView.getPeriod();
            if (period == null) continue;
            String message = period.getDay() + "\u65e5\u76ee\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
            this.updateStatusBar(message);
            try {
                PeriodLoader.parsePeriod(period, false);
            }
            catch (IOException e) {
                this.showNetworkError(village, e);
                return;
            }
            periodView.showTopics();
        }
    }

    private void actionShowFind() {
        FindPanel findPanel = this.windowManager.getFindPanel();
        findPanel.setVisible(true);
        if (findPanel.isCanceled()) {
            this.updateFindPanel();
            return;
        }
        if (findPanel.isBulkSearch()) {
            this.bulkSearch();
        } else {
            this.regexSearch();
        }
    }

    private void regexSearch() {
        Pattern pattern;
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        FindPanel findPanel = this.windowManager.getFindPanel();
        RegexPattern regPattern = findPanel.getRegexPattern();
        int hits = discussion.setRegexPattern(regPattern);
        String hitMessage = "\uff3b" + hits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f";
        this.updateStatusBar(hitMessage);
        String loginfo = "";
        if (regPattern != null && (pattern = regPattern.getPattern()) != null) {
            loginfo = "\u6b63\u898f\u8868\u73fe " + pattern.pattern() + " \u306b";
        }
        loginfo = loginfo + hitMessage;
        LOGGER.info(loginfo);
    }

    private void bulkSearch() {
        this.busyStatus.submitHeavyBusyTask(() -> this.taskBulkSearch(), null, null);
    }

    private void taskBulkSearch() {
        Pattern pattern;
        this.taskLoadAllPeriod();
        int totalhits = 0;
        FindPanel findPanel = this.windowManager.getFindPanel();
        RegexPattern regPattern = findPanel.getRegexPattern();
        StringBuilder hitDesc = new StringBuilder();
        TabBrowser browser = this.topView.getTabBrowser();
        for (PeriodView periodView : browser.getPeriodViewList()) {
            Discussion discussion = periodView.getDiscussion();
            int hits = discussion.setRegexPattern(regPattern);
            totalhits += hits;
            if (hits <= 0) continue;
            Period period = discussion.getPeriod();
            hitDesc.append(' ').append(period.getDay()).append("d:");
            hitDesc.append(hits).append("\u4ef6");
        }
        String hitMessage = "\uff3b" + totalhits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002" + hitDesc.toString();
        this.updateStatusBar(hitMessage);
        String loginfo = "";
        if (regPattern != null && (pattern = regPattern.getPattern()) != null) {
            loginfo = "\u6b63\u898f\u8868\u73fe " + pattern.pattern() + " \u306b";
        }
        loginfo = loginfo + hitMessage;
        LOGGER.info(loginfo);
    }

    private void updateFindPanel() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        RegexPattern pattern = discussion.getRegexPattern();
        FindPanel findPanel = this.windowManager.getFindPanel();
        findPanel.setRegexPattern(pattern);
    }

    private void actionDaySummary() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        DaySummary daySummary = this.windowManager.getDaySummary();
        daySummary.summaryPeriod(period);
        daySummary.setVisible(true);
    }

    private void actionDayExportCsv() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        File file = CsvExporter.exportPeriod(period, filterPanel);
        if (file != null) {
            String message = "CSV\u30d5\u30a1\u30a4\u30eb(" + file.getName() + ")\u3078\u306e\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f";
            this.updateStatusBar(message);
        }
    }

    private void actionSearchNext() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.nextHotTarget();
    }

    private void actionSearchPrev() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.prevHotTarget();
    }

    private void actionReloadPeriod() {
        this.updatePeriod(true);
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        if (village.getState() != VillageState.EPILOGUE) {
            return;
        }
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        if (period.getTopics() > 1000) {
            JOptionPane.showMessageDialog(this.getTopFrame(), "\u30a8\u30d4\u30ed\u30fc\u30b0\u304c1000\u767a\u8a00\u3092\u8d85\u3048\u306f\u3058\u3081\u305f\u3089\u3001\n\u8ca0\u8377\u5bfe\u7b56\u306e\u305f\u3081Web\u30d6\u30e9\u30a6\u30b6\u306b\u3088\u308b\u30a2\u30af\u30bb\u30b9\u3092\u5fc3\u304c\u3051\u307e\u3057\u3087\u3046", "\u9577\u5927\u30a8\u30d4\u30ed\u30fc\u30b0\u8b66\u544a", 2);
        }
    }

    private void actionLoadAllPeriod() {
        this.busyStatus.submitHeavyBusyTask(() -> this.taskLoadAllPeriod(), "\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb", "\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
    }

    private void taskLoadAllPeriod() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        for (PeriodView periodView : browser.getPeriodViewList()) {
            Period period = periodView.getPeriod();
            if (period == null) continue;
            String message = period.getDay() + "\u65e5\u76ee\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
            this.updateStatusBar(message);
            try {
                PeriodLoader.parsePeriod(period, false);
            }
            catch (IOException e) {
                this.showNetworkError(village, e);
                return;
            }
            periodView.showTopics();
        }
    }

    private void actionReloadVillageList() {
        JTree tree = this.topView.getTreeView();
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Land land = null;
        for (int ct = 0; ct < path.getPathCount(); ++ct) {
            Object obj = path.getPathComponent(ct);
            if (!(obj instanceof Land)) continue;
            land = (Land)obj;
            break;
        }
        if (land == null) {
            return;
        }
        this.topView.showInitPanel();
        this.submitReloadVillageList(land);
    }

    private void actionCopySelected() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copySelected();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.updateStatusBar("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionCopyTalk() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copyTalk();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.updateStatusBar("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private Period loadAnchoredPeriod(Village village, Anchor anchor) throws IOException {
        if (anchor.hasTalkNo()) {
            return null;
        }
        Period anchorPeriod = village.getPeriod(anchor);
        if (anchorPeriod == null) {
            return null;
        }
        PeriodLoader.parsePeriod(anchorPeriod, false);
        return anchorPeriod;
    }

    private void actionJumpAnchor() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = this.getVillage();
        Anchor anchor = discussion.getActiveAnchor();
        if (anchor == null) {
            return;
        }
        Runnable task = () -> {
            if (anchor.hasTalkNo()) {
                this.taskLoadAllPeriod();
            }
            try {
                this.loadAnchoredPeriod(village, anchor);
                List<Talk> talkList = village.getTalkListFromAnchor(anchor);
                if (talkList == null || talkList.size() <= 0) {
                    this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u30b8\u30e3\u30f3\u30d7\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                    return;
                }
                Talk targetTalk = talkList.get(0);
                Period targetPeriod = targetTalk.getPeriod();
                int periodIndex = targetPeriod.getDay();
                PeriodView target = browser.getPeriodView(periodIndex);
                EventQueue.invokeLater(() -> {
                    browser.showPeriodTab(periodIndex);
                    target.setPeriod(targetPeriod);
                    target.scrollToTalk(targetTalk);
                });
                this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306b\u30b8\u30e3\u30f3\u30d7\u3057\u307e\u3057\u305f");
            }
            catch (IOException e) {
                this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
            }
        };
        this.busyStatus.submitHeavyBusyTask(task, "\u30b8\u30e3\u30f3\u30d7\u5148\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u2026", null);
    }

    private void actionOpenXml() {
        int result = this.xmlFileChooser.showOpenDialog(this.getTopFrame());
        if (result != 0) {
            return;
        }
        File selected = this.xmlFileChooser.getSelectedFile();
        this.busyStatus.submitHeavyBusyTask(() -> {
            Village village;
            try {
                village = VillageLoader.parseVillage(selected);
            }
            catch (IOException e) {
                String warnMsg = MessageFormat.format("XML\u30d5\u30a1\u30a4\u30eb[ {0} ]\u3092\u8aad\u307f\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", selected.getPath());
                this.warnDialog("XML I/O error", warnMsg, e);
                return;
            }
            catch (SAXException e) {
                String warnMsg = MessageFormat.format("XML\u30d5\u30a1\u30a4\u30eb[ {0} ]\u306e\u5f62\u5f0f\u304c\u4e0d\u6b63\u306a\u305f\u3081\u8aad\u307f\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", selected.getPath());
                this.warnDialog("XML form error", warnMsg, e);
                return;
            }
            village.setLocalArchive(true);
            AvatarPics avatarPics = village.getAvatarPics();
            this.appSetting.applyLocalImage(avatarPics);
            avatarPics.preload();
            EventQueue.invokeLater(() -> this.selectedVillage(village));
        }, "XML\u8aad\u307f\u8fbc\u307f\u4e2d", "XML\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
    }

    private void submitReloadVillageList(Land land) {
        this.busyStatus.submitHeavyBusyTask(() -> this.taskReloadVillageList(land), "\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026", "\u6751\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
    }

    private void taskReloadVillageList(Land land) {
        List<Village> villageList;
        try {
            villageList = VillageListLoader.loadVillageList(land);
        }
        catch (IOException e) {
            this.showNetworkError(land, e);
            return;
        }
        land.updateVillageList(villageList);
        this.model.updateVillageList(land);
        LandsTree treePanel = this.topView.getLandsTree();
        treePanel.expandLand(land);
    }

    private void updatePeriod(boolean force) {
        Village village = this.getVillage();
        if (village == null) {
            return;
        }
        String fullName = village.getVillageFullName();
        this.setFrameTitle(fullName);
        PeriodView periodView = this.currentPeriodView();
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        discussion.setTopicFilter(filterPanel);
        Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        Runnable task = () -> {
            try {
                PeriodLoader.parsePeriod(period, force);
            }
            catch (IOException e) {
                this.showNetworkError(village, e);
                return;
            }
            EventQueue.invokeLater(() -> {
                int lastPos = periodView.getVerticalPosition();
                periodView.showTopics();
                periodView.setVerticalPosition(lastPos);
            });
        };
        this.busyStatus.submitHeavyBusyTask(task, "\u4f1a\u8a71\u306e\u8aad\u307f\u8fbc\u307f\u4e2d", "\u4f1a\u8a71\u306e\u8868\u793a\u304c\u5b8c\u4e86");
    }

    private void filterChanged() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        discussion.setTopicFilter(filterPanel);
        discussion.filtering();
    }

    public void showNetworkError(Village village, IOException e) {
        Land land = village.getParentLand();
        this.showNetworkError(land, e);
    }

    public void showNetworkError(Land land, IOException e) {
        LOGGER.log(Level.WARNING, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        ServerAccess server = land.getServerAccess();
        String message = land.getLandDef().getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + server.getBaseURL() + " ] \u3060\u3088\u3002\n\u30d7\u30ed\u30af\u30b7\u8a2d\u5b9a\u306f\u6b63\u3057\u3044\u304b\u306a\uff1f\nWeb\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d!\n";
        JOptionPane pane = new JOptionPane(message, 2, -1);
        String title = VerInfo.getFrameTitle("\u901a\u4fe1\u7570\u5e38\u767a\u751f");
        JDialog dialog = pane.createDialog(title);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void selectedLand(Land land) {
        String landName = land.getLandDef().getLandName();
        this.setFrameTitle(landName);
        this.actionManager.exposeVillage(false);
        this.actionManager.exposePeriod(false);
        this.topView.showLandInfo(land);
    }

    private void selectedVillage(Village village) {
        this.setFrameTitle(village.getVillageFullName());
        if (village.isLocalArchive()) {
            this.actionManager.exposeVillageLocal(true);
        } else {
            this.actionManager.exposeVillage(true);
        }
        Runnable task = () -> {
            try {
                if (!village.hasSchedule()) {
                    VillageInfoLoader.updateVillageInfo(village);
                }
            }
            catch (IOException e) {
                this.showNetworkError(village, e);
                return;
            }
            EventQueue.invokeLater(() -> this.topView.showVillageInfo(village));
        };
        this.busyStatus.submitHeavyBusyTask(task, "\u6751\u60c5\u5831\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026", "\u6751\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.busyStatus.isBusy()) {
            return;
        }
        String cmd = ev.getActionCommand();
        if (cmd == null) {
            return;
        }
        switch (cmd) {
            case "OPENXML": {
                this.actionOpenXml();
                break;
            }
            case "EXIT": {
                this.actionExit();
                break;
            }
            case "COPY": {
                this.actionCopySelected();
                break;
            }
            case "SHOWFIND": {
                this.actionShowFind();
                break;
            }
            case "SEARCHNEXT": {
                this.actionSearchNext();
                break;
            }
            case "SEARCHPREV": {
                this.actionSearchPrev();
                break;
            }
            case "ALLPERIOD": {
                this.actionLoadAllPeriod();
                break;
            }
            case "DIGEST": {
                this.actionShowDigest();
                break;
            }
            case "WEBVILL": {
                this.actionShowWebVillage();
                break;
            }
            case "WEBWIKI": {
                this.actionShowWebWiki();
                break;
            }
            case "RELOAD": {
                this.actionReloadPeriod();
                break;
            }
            case "DAYSUMMARY": {
                this.actionDaySummary();
                break;
            }
            case "DAYEXPCSV": {
                this.actionDayExportCsv();
                break;
            }
            case "WEBDAY": {
                this.actionShowWebDay();
                break;
            }
            case "OPTION": {
                this.actionOption();
                break;
            }
            case "LANDF": {
                this.actionChangeLaF();
                break;
            }
            case "SHOWFILT": {
                this.actionShowFilter();
                break;
            }
            case "SHOWLOG": {
                this.actionShowLog();
                break;
            }
            case "HELPDOC": {
                this.actionHelp();
                break;
            }
            case "SHOWPORTAL": {
                this.actionShowPortal();
                break;
            }
            case "ABOUT": {
                this.actionAbout();
                break;
            }
            case "VILLAGELIST": {
                this.actionReloadVillageList();
                break;
            }
            case "COPYTALK": {
                this.actionCopyTalk();
                break;
            }
            case "JUMPANCHOR": {
                this.actionJumpAnchor();
                break;
            }
            case "WEBTALK": {
                this.actionShowWebTalk();
                break;
            }
        }
    }

    @Override
    public void anchorHitted(AnchorHitEvent event) {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        Village village = period.getVillage();
        TalkDraw talkDraw = event.getTalkDraw();
        Anchor anchor = event.getAnchor();
        Discussion discussion = periodView.getDiscussion();
        Runnable task = () -> {
            if (anchor.hasTalkNo()) {
                this.taskLoadAllPeriod();
            }
            try {
                this.loadAnchoredPeriod(village, anchor);
                List<Talk> talkList = village.getTalkListFromAnchor(anchor);
                if (talkList == null || talkList.size() <= 0) {
                    this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                    return;
                }
                EventQueue.invokeLater(() -> {
                    talkDraw.showAnchorTalks(anchor, talkList);
                    discussion.layoutRows();
                });
                this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306e\u5c55\u958b\u5b8c\u4e86");
            }
            catch (IOException e) {
                this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
            }
        };
        this.busyStatus.submitHeavyBusyTask(task, "\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u2026", null);
    }

    private void shutdown() {
        JsObject findConf;
        JsonIo jsonIo = this.appSetting.getJsonIo();
        FindPanel findPanel = this.windowManager.getFindPanel();
        if (!findPanel.hasConfChanged(findConf = findPanel.getJson())) {
            jsonIo.saveHistoryConfig(findConf);
        }
        this.appSetting.saveConfig();
        LOGGER.info("VM\u3054\u3068\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
        System.exit(0);
        assert (false);
    }

    private class VillageTreeWatcher
    implements TreeSelectionListener,
    TreeWillExpandListener {
        VillageTreeWatcher() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath path = event.getNewLeadSelectionPath();
            if (path == null) {
                return;
            }
            Object selObj = path.getLastPathComponent();
            if (selObj instanceof Land) {
                Land land = (Land)selObj;
                Controller.this.selectedLand(land);
            } else if (selObj instanceof Village) {
                Village village = (Village)selObj;
                village.setLocalArchive(false);
                Controller.this.selectedVillage(village);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
            if (!(event.getSource() instanceof JTree)) {
                return;
            }
            TreePath path = event.getPath();
            Object lastObj = path.getLastPathComponent();
            if (!(lastObj instanceof Land)) {
                return;
            }
            Land land = (Land)lastObj;
            if (land.getVillageCount() > 0) {
                return;
            }
            Controller.this.submitReloadVillageList(land);
        }
    }

    private class TabPeriodWatcher
    implements ChangeListener {
        TabPeriodWatcher() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Object source = event.getSource();
            if (source instanceof TabBrowser) {
                Controller.this.updateFindPanel();
                Controller.this.updatePeriod(false);
                PeriodView periodView = Controller.this.currentPeriodView();
                boolean hasCurrentPeriod = periodView != null;
                Controller.this.actionManager.exposePeriod(hasCurrentPeriod);
                if (hasCurrentPeriod) {
                    Village village = Controller.this.getVillage();
                    if (village.isLocalArchive()) {
                        Controller.this.actionManager.exposeVillageLocal(hasCurrentPeriod);
                    } else {
                        Controller.this.actionManager.exposeVillage(hasCurrentPeriod);
                    }
                }
            }
        }
    }

    private class FilterWatcher
    implements ChangeListener {
        FilterWatcher() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Object source = event.getSource();
            if (source == Controller.this.windowManager.getFilterPanel()) {
                Controller.this.filterChanged();
            }
        }
    }
}

