/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.UIManager;
import jp.sfjp.jindolf.Controller;
import jp.sfjp.jindolf.Jindolf;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.config.AppSetting;
import jp.sfjp.jindolf.config.CmdOption;
import jp.sfjp.jindolf.config.ConfigDirUi;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.EnvInfo;
import jp.sfjp.jindolf.config.FileUtils;
import jp.sfjp.jindolf.config.OptionInfo;
import jp.sfjp.jindolf.data.LandsTreeModel;
import jp.sfjp.jindolf.log.LogUtils;
import jp.sfjp.jindolf.log.LoggingDispatcher;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.view.ActionManager;
import jp.sfjp.jindolf.view.TopFrame;
import jp.sfjp.jindolf.view.WindowManager;

public final class JindolfMain {
    public static final long NANOCT_LOADED;
    public static final long EPOCHMS_LOADED;
    private static final Logger LOGGER;
    private static final String LOG_LOADED = "{0} \u306f {1,date} {2,time} \u306bVM\u4e0a\u306e\u30af\u30e9\u30b9 {3} \u3068\u3057\u3066\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002 ";
    private static final String LOG_NANOCT = "Initial Nano-Count : {0}";
    private static final String LOG_HEAP = "Max-heap : {0} Bytes   Total-heap : {1} Bytes";
    private static final String LOG_CONF = "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b[ {0} ]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
    private static final String LOG_NOCONF = "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u4f7f\u3044\u307e\u305b\u3093\u3002";
    private static final String FATALMSG_INITFAIL = "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f";
    private static final String ERRMSG_HELP = "\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u4e00\u89a7\u306f\u3001\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u300c{0}\u300d\u3092\u6307\u5b9a\u3059\u308b\u3068\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002";
    private static final PrintStream STDOUT;
    private static final PrintStream STDERR;

    private JindolfMain() {
        assert (false);
    }

    private static void flush() {
        STDOUT.flush();
        STDERR.flush();
    }

    private static void showHelpMessage() {
        JindolfMain.flush();
        String helpText = CmdOption.getHelpText();
        STDOUT.print(helpText);
        JindolfMain.flush();
    }

    private static void logBootInfo() {
        Object[] logArgs = new Object[]{VerInfo.ID, EPOCHMS_LOADED, EPOCHMS_LOADED, Jindolf.class.getName()};
        LOGGER.log(Level.INFO, LOG_LOADED, logArgs);
        LOGGER.log(Level.INFO, LOG_NANOCT, NANOCT_LOADED);
        Runtime runtime = Runtime.getRuntime();
        logArgs = new Object[]{runtime.maxMemory(), runtime.totalMemory()};
        LOGGER.log(Level.INFO, LOG_HEAP, logArgs);
        if (FileUtils.isWindowsOSFs()) {
            LOGGER.info("Windows\u74b0\u5883\u3068\u8a8d\u8b58\u3055\u308c\u307e\u3057\u305f\u3002");
        }
        if (FileUtils.isMacOSXFs()) {
            LOGGER.info("macOS\u74b0\u5883\u3068\u8a8d\u8b58\u3055\u308c\u307e\u3057\u305f\u3002");
        }
        Locale locale = Locale.getDefault();
        String localeTxt = locale.toString();
        LOGGER.log(Level.INFO, "\u30ed\u30b1\u30fc\u30eb\u306b{0}\u304c\u7528\u3044\u3089\u308c\u307e\u3059\u3002", localeTxt);
    }

    private static void logBootInfo(OptionInfo optinfo) {
        StringBuilder bootArgs = new StringBuilder();
        bootArgs.append("\n\n").append("\u8d77\u52d5\u6642\u5f15\u6570:\n");
        optinfo.getInvokeArgList().forEach(arg -> bootArgs.append("  ").append((String)arg).append('\n'));
        bootArgs.append('\n');
        bootArgs.append(EnvInfo.getVMInfo());
        LOGGER.info(bootArgs.toString());
    }

    private static void logBootInfo(ConfigStore configStore) {
        if (configStore.useStoreFile()) {
            LOGGER.log(Level.INFO, LOG_CONF, configStore.getConfigDir());
        } else {
            LOGGER.info(LOG_NOCONF);
        }
    }

    public static int main(String ... args) {
        OptionInfo optinfo;
        try {
            optinfo = OptionInfo.parseOptions(args);
        }
        catch (IllegalArgumentException e) {
            String message = e.getLocalizedMessage();
            STDERR.println(message);
            String info = MessageFormat.format(ERRMSG_HELP, new Object[]{CmdOption.OPT_HELP});
            STDERR.println(info);
            int exitCode = 1;
            return exitCode;
        }
        int exitCode = JindolfMain.main(optinfo);
        return exitCode;
    }

    public static int main(OptionInfo optinfo) {
        if (optinfo.hasOption(CmdOption.OPT_HELP)) {
            JindolfMain.showHelpMessage();
            int exitCode = 0;
            return exitCode;
        }
        if (optinfo.hasOption(CmdOption.OPT_VERSION)) {
            STDOUT.println(VerInfo.ID);
            int exitCode = 0;
            return exitCode;
        }
        Boolean boldFlag = optinfo.hasOption(CmdOption.OPT_BOLDMETAL) ? Boolean.TRUE : Boolean.FALSE;
        UIManager.put("swing.boldMetal", boldFlag);
        int exitCode = JindolfMain.splashedMain(optinfo);
        return exitCode;
    }

    public static int splashedMain(OptionInfo optinfo) {
        if (optinfo.hasOption(CmdOption.OPT_VMINFO)) {
            STDOUT.println(EnvInfo.getVMInfo());
        }
        LogUtils.initRootLogger(optinfo.hasOption(CmdOption.OPT_CONSOLELOG));
        JindolfMain.logBootInfo();
        JindolfMain.logBootInfo(optinfo);
        AppSetting appSetting = new AppSetting(optinfo);
        ConfigStore configStore = appSetting.getConfigStore();
        JindolfMain.logBootInfo(configStore);
        ConfigDirUi.prepareConfigDir(configStore);
        ConfigDirUi.tryLock(configStore);
        appSetting.loadConfig();
        LoggingDispatcher.replaceEventQueue();
        int exitCode = 0;
        try {
            EventQueue.invokeAndWait(() -> JindolfMain.startGUI(appSetting));
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, FATALMSG_INITFAIL, e);
            e.printStackTrace(STDERR);
            exitCode = 1;
        }
        return exitCode;
    }

    private static void startGUI(AppSetting appSetting) {
        JFrame topFrame = JindolfMain.buildMVC(appSetting);
        GUIUtils.modifyWindowAttributes(topFrame, true, false, true);
        topFrame.pack();
        int frameWidth = appSetting.initialFrameWidth();
        int frameHeight = appSetting.initialFrameHeight();
        Dimension initGeometry = new Dimension(frameWidth, frameHeight);
        topFrame.setSize(initGeometry);
        int frameXpos = appSetting.initialFrameXpos();
        int frameYpos = appSetting.initialFrameYpos();
        if (frameXpos <= Integer.MIN_VALUE || frameYpos <= Integer.MIN_VALUE) {
            topFrame.setLocationByPlatform(true);
        } else {
            topFrame.setLocation(frameXpos, frameYpos);
        }
        topFrame.setVisible(true);
    }

    private static JFrame buildMVC(AppSetting appSetting) {
        LandsTreeModel model = new LandsTreeModel();
        WindowManager windowManager = new WindowManager();
        ActionManager actionManager = new ActionManager();
        Controller controller = new Controller(model, windowManager, actionManager, appSetting);
        TopFrame topFrame = controller.getTopFrame();
        return topFrame;
    }

    static {
        LOGGER = Logger.getAnonymousLogger();
        STDOUT = System.out;
        STDERR = System.err;
        NANOCT_LOADED = System.nanoTime();
        EPOCHMS_LOADED = System.currentTimeMillis();
    }
}

