/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jp.sfjp.jindolf.Jindolf;
import jp.sfjp.jindolf.view.FlexiIcon;

public final class ResourceManager {
    public static final Package DEF_ROOT_PACKAGE;
    private static final Class<?> ROOT_KLASS;
    private static final ClassLoader DEF_LOADER;
    private static final char PKG_SEPCHAR = '.';
    private static final char RES_SEPCHAR = '/';
    private static final String RES_SEPARATOR;
    private static final Charset CS_UTF8;
    private static final int BTN_SZ = 24;

    private ResourceManager() {
        assert (false);
    }

    private static boolean isAbsoluteResourcePath(String resPath) {
        return resPath.startsWith(RES_SEPARATOR);
    }

    private static String getResourcePrefix(Package pkg) {
        if (pkg == null) {
            return "";
        }
        String pkgName = pkg.getName();
        String result = pkgName.replace('.', '/');
        if (!result.isEmpty()) {
            result = result + RES_SEPARATOR;
        }
        assert (result.charAt(0) != '/');
        return result;
    }

    public static URL getResource(String resPath) {
        return ResourceManager.getResource(DEF_ROOT_PACKAGE, resPath);
    }

    private static URL getResource(Package rootPkg, String resPath) {
        return ResourceManager.getResource(DEF_LOADER, rootPkg, resPath);
    }

    private static URL getResource(ClassLoader loader, Package rootPkg, String resPath) {
        String fullName;
        if (ResourceManager.isAbsoluteResourcePath(resPath)) {
            fullName = resPath.substring(1);
        } else {
            String pfx = ResourceManager.getResourcePrefix(rootPkg);
            fullName = pfx + resPath;
        }
        assert (!ResourceManager.isAbsoluteResourcePath(fullName));
        URL result = loader.getResource(fullName);
        return result;
    }

    public static InputStream getResourceAsStream(String resPath) {
        return ResourceManager.getResourceAsStream(DEF_ROOT_PACKAGE, resPath);
    }

    private static InputStream getResourceAsStream(Package rootPkg, String resPath) {
        return ResourceManager.getResourceAsStream(DEF_LOADER, rootPkg, resPath);
    }

    private static InputStream getResourceAsStream(ClassLoader loader, Package rootPkg, String resPath) {
        InputStream result;
        URL url = ResourceManager.getResource(loader, rootPkg, resPath);
        if (url == null) {
            return null;
        }
        try {
            result = url.openStream();
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static BufferedImage getBufferedImage(String resPath) {
        BufferedImage result;
        URL url = ResourceManager.getResource(resPath);
        if (url == null) {
            return null;
        }
        try {
            result = ImageIO.read(url);
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static ImageIcon getImageIcon(String resPath) {
        URL url = ResourceManager.getResource(resPath);
        if (url == null) {
            return null;
        }
        ImageIcon result = new ImageIcon(url);
        return result;
    }

    public static Icon getButtonIcon(String resPath) {
        Icon result = ResourceManager.getSquareIcon(resPath, 24);
        return result;
    }

    public static Icon getSquareIcon(String resPath, int sz) {
        BufferedImage image = ResourceManager.getBufferedImage(resPath);
        FlexiIcon result = new FlexiIcon(image, sz, sz);
        return result;
    }

    public static Properties getProperties(String resPath) {
        InputStream is = ResourceManager.getResourceAsStream(resPath);
        if (is == null) {
            return null;
        }
        Properties properties = new Properties();
        try (BufferedInputStream pis = new BufferedInputStream(is);){
            properties.load(pis);
        }
        catch (IOException e) {
            properties = null;
        }
        return properties;
    }

    public static String getTextFile(String resPath) {
        InputStream is = ResourceManager.getResourceAsStream(resPath);
        if (is == null) {
            return null;
        }
        is = new BufferedInputStream(is);
        InputStreamReader reader = new InputStreamReader(is, CS_UTF8);
        StringBuilder result = new StringBuilder();
        try (LineNumberReader lineReader = new LineNumberReader(reader);){
            String line;
            while ((line = lineReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                result.append(line).append('\n');
            }
        }
        catch (IOException e) {
            result = null;
        }
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    static {
        ROOT_KLASS = Jindolf.class;
        RES_SEPARATOR = Character.toString('/');
        CS_UTF8 = StandardCharsets.UTF_8;
        DEF_ROOT_PACKAGE = ROOT_KLASS.getPackage();
        DEF_LOADER = ROOT_KLASS.getClassLoader();
    }
}

