/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import jp.sfjp.jindolf.config.CmdOption;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.JsonIo;
import jp.sfjp.jindolf.config.OptionInfo;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.glyph.Font2Json;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.net.ProxyInfo;
import jp.sfjp.jindolf.view.AvatarPics;
import jp.sfjp.jindolf.view.LocalAvatarImg;
import jp.sourceforge.jovsonz.JsBoolean;
import jp.sourceforge.jovsonz.JsObject;
import jp.sourceforge.jovsonz.JsPair;
import jp.sourceforge.jovsonz.JsString;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;

public class AppSetting {
    private static final int DEF_WIDTH = 800;
    private static final int DEF_HEIGHT = 600;
    private static final String HASH_FONT = "font";
    private static final String HASH_USEBODYICON = "useBodyIcon";
    private static final String HASH_USEMONOTOMB = "useMonoTomb";
    private static final String HASH_SIMPLEMODE = "isSimpleMode";
    private static final String HASH_ALIGNBALOON = "alignBaloonWidth";
    private static final String HASH_PROXY = "proxy";
    private static final String MSG_NOIMG = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb{0}\u304c\u8aad\u307f\u8fbc\u3081\u306a\u3044\u305f\u3081{1}\u306e\u8868\u793a\u306b\u4ee3\u66ff\u30a4\u30e1\u30fc\u30b8\u3092\u4f7f\u3044\u307e\u3059\u3002";
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final OptionInfo optInfo;
    private final ConfigStore configStore;
    private final JsonIo jsonIo;
    private final Rectangle frameRect;
    private FontInfo fontInfo;
    private ProxyInfo proxyInfo = ProxyInfo.DEFAULT;
    private DialogPref dialogPref = new DialogPref();
    private JsValue loadedNetConfig;
    private JsValue loadedTalkConfig;
    private final Map<String, BufferedImage> avatarFaceMap = new HashMap<String, BufferedImage>();
    private final Map<String, BufferedImage> avatarBodyMap = new HashMap<String, BufferedImage>();

    public AppSetting(OptionInfo info) {
        this.optInfo = info;
        this.configStore = AppSetting.parseConfigStore(this.optInfo);
        this.jsonIo = new JsonIo(this.configStore);
        this.frameRect = AppSetting.parseGeometrySetting(this.optInfo);
    }

    private static ConfigStore parseConfigStore(OptionInfo option) {
        ConfigStore result;
        CmdOption opt = option.getExclusiveOption(CmdOption.OPT_CONFDIR, CmdOption.OPT_NOCONF);
        if (opt == null) {
            result = new ConfigStore(null);
        } else {
            switch (opt) {
                case OPT_NOCONF: {
                    result = new ConfigStore();
                    break;
                }
                case OPT_CONFDIR: {
                    String optArg = option.getStringArg(opt);
                    Path configPath = Paths.get(optArg, new String[0]);
                    configPath = configPath.toAbsolutePath();
                    result = new ConfigStore(configPath);
                    break;
                }
                default: {
                    result = null;
                    assert (false);
                    break;
                }
            }
        }
        return result;
    }

    private static Rectangle parseGeometrySetting(OptionInfo option) {
        Rectangle result = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, 800, 600);
        Integer ival = option.initialFrameWidth();
        if (ival != null) {
            result.width = ival;
        }
        if ((ival = option.initialFrameHeight()) != null) {
            result.height = ival;
        }
        if ((ival = option.initialFrameXpos()) != null) {
            result.x = ival;
        }
        if ((ival = option.initialFrameYpos()) != null) {
            result.y = ival;
        }
        return result;
    }

    private FontInfo parseFontOption(FontInfo baseFont) {
        Boolean useFractional;
        FontInfo result;
        String fontName = this.optInfo.getStringArg(CmdOption.OPT_INITFONT);
        if (fontName != null) {
            Font font = Font.decode(fontName);
            result = baseFont.deriveFont(font);
        } else {
            result = baseFont;
        }
        Boolean useAntiAlias = this.optInfo.getBooleanArg(CmdOption.OPT_ANTIALIAS);
        if (useAntiAlias == null) {
            useAntiAlias = baseFont.isAntiAliased();
        }
        if ((useFractional = this.optInfo.getBooleanArg(CmdOption.OPT_FRACTIONAL)) == null) {
            useFractional = baseFont.usesFractionalMetrics();
        }
        result = result.deriveRenderContext(useAntiAlias, useFractional);
        return result;
    }

    public OptionInfo getOptionInfo() {
        return this.optInfo;
    }

    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    public JsonIo getJsonIo() {
        return this.jsonIo;
    }

    public int initialFrameWidth() {
        int width = this.frameRect.width;
        return width;
    }

    public int initialFrameHeight() {
        int height = this.frameRect.height;
        return height;
    }

    public int initialFrameXpos() {
        int xPos = this.frameRect.x;
        return xPos;
    }

    public int initialFrameYpos() {
        int yPos = this.frameRect.y;
        return yPos;
    }

    public FontInfo getFontInfo() {
        if (this.fontInfo == null) {
            this.fontInfo = this.parseFontOption(FontInfo.DEFAULT_FONTINFO);
        }
        return this.fontInfo;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo == null ? ProxyInfo.DEFAULT : proxyInfo;
    }

    public DialogPref getDialogPref() {
        return this.dialogPref;
    }

    public void setDialogPref(DialogPref pref) {
        this.dialogPref = pref == null ? new DialogPref() : pref;
    }

    private void loadNetConfig() {
        JsObject root = this.jsonIo.loadNetConfig();
        if (root == null) {
            return;
        }
        this.loadedNetConfig = root;
        JsValue value = root.getValue(HASH_PROXY);
        if (!(value instanceof JsObject)) {
            return;
        }
        JsObject proxy = (JsObject)value;
        ProxyInfo info = ProxyInfo.decodeJson(proxy);
        this.setProxyInfo(info);
    }

    private void loadTalkConfig() {
        JsBoolean boolValue;
        JsObject root = this.jsonIo.loadTalkConfig();
        if (root == null) {
            return;
        }
        this.loadedTalkConfig = root;
        JsValue value = root.getValue(HASH_FONT);
        if (value instanceof JsObject) {
            JsObject font = (JsObject)value;
            FontInfo info = Font2Json.decodeJson(font);
            info = this.parseFontOption(info);
            this.setFontInfo(info);
        }
        DialogPref pref = new DialogPref();
        value = root.getValue(HASH_USEBODYICON);
        if (value instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setBodyImageSetting(boolValue.booleanValue());
        }
        if ((value = root.getValue(HASH_USEMONOTOMB)) instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setMonoImageSetting(boolValue.booleanValue());
        }
        if ((value = root.getValue(HASH_SIMPLEMODE)) instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setSimpleMode(boolValue.booleanValue());
        }
        if ((value = root.getValue(HASH_ALIGNBALOON)) instanceof JsBoolean) {
            boolValue = (JsBoolean)value;
            pref.setAlignBalooonWidthSetting(boolValue.booleanValue());
        }
        this.setDialogPref(pref);
    }

    private void parseImgMap(JsObject json, Map<String, BufferedImage> map) {
        Path imgDir = this.configStore.getLocalImgDir();
        List<JsPair> pairList = json.getPairList();
        for (JsPair pair : pairList) {
            BufferedImage image;
            String avatarId = pair.getName();
            JsValue value = pair.getValue();
            if (value.getJsTypes() != JsTypes.STRING) continue;
            JsString sVal = (JsString)value;
            String imgName = sVal.toRawString();
            Path imgPath = Paths.get(imgName, new String[0]);
            Path full = imgDir.resolve(imgPath);
            File file = full.toFile();
            if (!(file.isAbsolute() && file.exists() && file.isFile() && file.canRead())) {
                String msg = MessageFormat.format(MSG_NOIMG, file.getPath(), avatarId);
                LOGGER.info(msg);
                continue;
            }
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                String msg = MessageFormat.format(MSG_NOIMG, file.getPath(), avatarId);
                LOGGER.info(msg);
                continue;
            }
            map.put(avatarId, image);
        }
    }

    private void loadLocalImageConfig() {
        JsObject root = this.jsonIo.loadLocalImgConfig();
        if (root == null) {
            return;
        }
        JsValue faceConfig = root.getValue("avatarFace");
        JsValue bodyConfig = root.getValue("avatarBody");
        if (faceConfig.getJsTypes() != JsTypes.OBJECT) {
            return;
        }
        if (bodyConfig.getJsTypes() != JsTypes.OBJECT) {
            return;
        }
        JsObject jsonFace = (JsObject)faceConfig;
        this.parseImgMap(jsonFace, this.avatarFaceMap);
        JsObject jsonBody = (JsObject)bodyConfig;
        this.parseImgMap(jsonBody, this.avatarBodyMap);
    }

    public void applyLocalImage(AvatarPics avatarPics) {
        BufferedImage graveImage = this.avatarFaceMap.get("tomb");
        BufferedImage graveBodyImage = this.avatarBodyMap.get("tomb");
        if (graveImage == null) {
            graveImage = LocalAvatarImg.getGraveImage();
        }
        if (graveBodyImage == null) {
            graveBodyImage = LocalAvatarImg.getGraveBodyImage();
        }
        avatarPics.setGraveImage(graveImage);
        avatarPics.setGraveBodyImage(graveBodyImage);
        for (Avatar avatar : Avatar.getPredefinedAvatarList()) {
            String avatarId = avatar.getIdentifier();
            BufferedImage faceImage = this.avatarFaceMap.get(avatarId);
            BufferedImage bodyImage = this.avatarBodyMap.get(avatarId);
            if (faceImage == null) {
                faceImage = LocalAvatarImg.getAvatarFaceImage(avatarId);
            }
            if (bodyImage == null) {
                bodyImage = LocalAvatarImg.getAvatarBodyImage(avatarId);
            }
            avatarPics.setAvatarFaceImage(avatar, faceImage);
            avatarPics.setAvatarBodyImage(avatar, bodyImage);
        }
    }

    private void saveNetConfig() {
        if (!this.getConfigStore().useStoreFile()) {
            return;
        }
        JsObject root = new JsObject();
        JsObject proxy = ProxyInfo.buildJson(this.getProxyInfo());
        root.putValue(HASH_PROXY, proxy);
        if (this.loadedNetConfig != null && this.loadedNetConfig.equals(root)) {
            return;
        }
        this.jsonIo.saveNetConfig(root);
    }

    private void saveTalkConfig() {
        if (!this.getConfigStore().useStoreFile()) {
            return;
        }
        JsObject root = new JsObject();
        JsObject font = Font2Json.buildJson(this.getFontInfo());
        root.putValue(HASH_FONT, font);
        DialogPref pref = this.getDialogPref();
        JsPair useBodyIcon = new JsPair(HASH_USEBODYICON, pref.useBodyImage());
        JsPair useMonoTomb = new JsPair(HASH_USEMONOTOMB, pref.useMonoImage());
        JsPair isSimple = new JsPair(HASH_SIMPLEMODE, pref.isSimpleMode());
        JsPair alignBaloon = new JsPair(HASH_ALIGNBALOON, pref.alignBaloonWidth());
        root.putPair(useBodyIcon);
        root.putPair(useMonoTomb);
        root.putPair(isSimple);
        root.putPair(alignBaloon);
        if (this.loadedTalkConfig != null && this.loadedTalkConfig.equals(root)) {
            return;
        }
        this.jsonIo.saveTalkConfig(root);
    }

    public void loadConfig() {
        this.loadNetConfig();
        this.loadTalkConfig();
        this.loadLocalImageConfig();
    }

    public void saveConfig() {
        this.saveNetConfig();
        this.saveTalkConfig();
    }
}

