/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import jp.sfjp.jindolf.ResourceManager;

public final class CmdOption
extends Enum<CmdOption> {
    public static final /* enum */ CmdOption OPT_HELP = new CmdOption("-help", "-h", "--help", "-?");
    public static final /* enum */ CmdOption OPT_VERSION = new CmdOption("-version");
    public static final /* enum */ CmdOption OPT_BOLDMETAL = new CmdOption("-boldMetal");
    public static final /* enum */ CmdOption OPT_GEOMETRY = new CmdOption("-geometry");
    public static final /* enum */ CmdOption OPT_VMINFO = new CmdOption("-vminfo");
    public static final /* enum */ CmdOption OPT_CONSOLELOG = new CmdOption("-consolelog");
    public static final /* enum */ CmdOption OPT_INITFONT = new CmdOption("-initfont");
    public static final /* enum */ CmdOption OPT_ANTIALIAS = new CmdOption("-antialias");
    public static final /* enum */ CmdOption OPT_FRACTIONAL = new CmdOption("-fractional");
    public static final /* enum */ CmdOption OPT_CONFDIR = new CmdOption("-confdir");
    public static final /* enum */ CmdOption OPT_NOCONF = new CmdOption("-noconfdir");
    private static final Collection<CmdOption> OPTS_INDEPENDENT;
    private static final Collection<CmdOption> OPTS_BOOLEAN;
    private static final String RES_DIR = "resources";
    private static final String RES_HELPTEXT = "resources/help.txt";
    private final List<String> nameList;
    private static final /* synthetic */ CmdOption[] $VALUES;

    public static CmdOption[] values() {
        return (CmdOption[])$VALUES.clone();
    }

    public static CmdOption valueOf(String name) {
        return Enum.valueOf(CmdOption.class, name);
    }

    private CmdOption(String ... names) {
        assert (names.length > 0);
        this.nameList = Arrays.asList(names);
    }

    public static String getHelpText() {
        String helpText = ResourceManager.getTextFile(RES_HELPTEXT);
        return helpText;
    }

    public static CmdOption parseCmdOption(String arg) {
        for (CmdOption option : CmdOption.values()) {
            if (!option.matches(arg)) continue;
            return option;
        }
        return null;
    }

    public boolean matches(String option) {
        boolean result = this.nameList.contains(option);
        return result;
    }

    public boolean isIndepOption() {
        boolean result = OPTS_INDEPENDENT.contains((Object)this);
        return result;
    }

    public boolean isBooleanOption() {
        boolean result = OPTS_BOOLEAN.contains((Object)this);
        return result;
    }

    public String toString() {
        String result = this.nameList.get(0);
        return result;
    }

    static {
        $VALUES = new CmdOption[]{OPT_HELP, OPT_VERSION, OPT_BOLDMETAL, OPT_GEOMETRY, OPT_VMINFO, OPT_CONSOLELOG, OPT_INITFONT, OPT_ANTIALIAS, OPT_FRACTIONAL, OPT_CONFDIR, OPT_NOCONF};
        OPTS_INDEPENDENT = EnumSet.of(OPT_HELP, new CmdOption[]{OPT_VERSION, OPT_VMINFO, OPT_BOLDMETAL, OPT_CONSOLELOG, OPT_NOCONF});
        OPTS_BOOLEAN = EnumSet.of(OPT_ANTIALIAS, OPT_FRACTIONAL);
    }
}

