/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.config.CmdOption;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.FileUtils;
import jp.sfjp.jindolf.config.InterVMLock;
import jp.sfjp.jindolf.view.LockErrorPane;

public final class ConfigDirUi {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final String TITLE_BUILDCONF = VerInfo.TITLE + "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u8a2d\u5b9a";
    private static final Path FILE_README = Paths.get("README.txt", new String[0]);
    private static final Path FILE_AVATARJSON = Paths.get("avatarCache.json", new String[0]);
    private static final String RES_DIR = "resources";
    private static final String RES_README = "resources/README.txt";
    private static final String RES_IMGDIR = "resources/image";
    private static final String RES_AVATARJSON = "resources/image/avatarCache.json";
    private static final String MSG_POST = "<ul><li><code>" + (Object)((Object)CmdOption.OPT_CONFDIR) + "</code>&nbsp;\u30aa\u30d7\u30b7\u30e7\u30f3\u6307\u5b9a\u306b\u3088\u308a\u3001<br/>\u4efb\u610f\u306e\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002<br/><li><code>" + (Object)((Object)CmdOption.OPT_NOCONF) + "</code>&nbsp;\u30aa\u30d7\u30b7\u30e7\u30f3\u6307\u5b9a\u306b\u3088\u308a\u3001<br/>\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f7f\u308f\u305a\u306b\u8d77\u52d5\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002<br/></ul>";
    private static final String MSG_NOCONF = "<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f7f\u308f\u305a\u306b\u8d77\u52d5\u3092\u7d9a\u884c\u3057\u307e\u3059\u3002<br/>\u4eca\u56de\u3001\u5404\u7a2e\u8a2d\u5b9a\u306e\u8aad\u307f\u8fbc\u307f\u30fb\u4fdd\u5b58\u306f\u3067\u304d\u307e\u305b\u3093\u3002<br/><code>" + (Object)((Object)CmdOption.OPT_NOCONF) + "</code> \u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u4f7f\u3046\u3068\u3053\u306e\u8b66\u544a\u306f\u51fa\u306a\u304f\u306a\u308a\u307e\u3059\u3002</html>";
    private static final String MSG_ABORT = "<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u3092\u305b\u305a\u306b\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br/>" + MSG_POST + "</html>";
    private static final String FORM_FAILRM = "<html>\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb\u306e\u5f37\u5236\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br/>\u4ed6\u306b\u52d5\u3044\u3066\u3044\u308bJindolf\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u306e\u3067\u3042\u308c\u3070\u3001<br/>\u306a\u3093\u3068\u304b\u3057\u3066\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb<br/>{0}\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br/>\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002</html>";
    private static final String FORM_ILLLOCK = "<html>\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb<br/>{0}\u3092\u78ba\u4fdd\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002<br/>\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002</html>";
    private static final String FORM_MKDIRFAIL = "<html>\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br/>{0}\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br/>" + MSG_POST + "</html>";
    private static final String FORM_ACCERR = "<html>\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br/>{0}\u3078\u306e\u30a2\u30af\u30bb\u30b9\u304c\u3067\u304d\u307e\u305b\u3093\u3002\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br/>\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3078\u306e\u30a2\u30af\u30bb\u30b9\u6a29\u3092\u8abf\u6574\u3057\u8aad\u307f\u66f8\u304d\u3067\u304d\u308b\u3088\u3046\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br/>" + MSG_POST + "</html>";
    private static final String FORM_WRITEERR = "<html>\u30d5\u30a1\u30a4\u30eb<br/>{0}\u3078\u306e\u66f8\u304d\u8fbc\u307f\u304c\u3067\u304d\u307e\u305b\u3093\u3002\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br/></html>";
    private static final String FORM_MKCONF = "<html>\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br/>{0}\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002<br/>\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4eca\u304b\u3089\u4f5c\u6210\u3057\u3066\u69cb\u3044\u307e\u305b\u3093\u304b\uff1f<br/>\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u306f\u3001\u5f8c\u304b\u3089\u3044\u3064\u3067\u3082\u30d8\u30eb\u30d7\u30a6\u30a3\u30f3\u30c9\u30a6\u3067<br/>\u78ba\u8a8d\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002</html>";
    private static final String LOG_MKDIRERR = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea{0}\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093";
    private static final String LOG_CREATEERR = "\u30d5\u30a1\u30a4\u30eb{0}\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093";
    private static final String LOG_RESCPY = "\u5185\u90e8\u30ea\u30bd\u30fc\u30b9\u304b\u3089{0}\u3078\u30b3\u30d4\u30fc\u304c\u884c\u308f\u308c\u307e\u3057\u305f\u3002";
    private static final int ERR_ABORT = 1;

    private ConfigDirUi() {
        assert (false);
    }

    private static void abort() {
        System.exit(1);
        assert (false);
    }

    private static void showDialog(JOptionPane pane) {
        JDialog dialog = pane.createDialog(TITLE_BUILDCONF);
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private static void showErrorMessage(String txt) {
        JOptionPane pane = new JOptionPane(txt, 0);
        ConfigDirUi.showDialog(pane);
    }

    private static String getCenteredFileName(Path path) {
        String form = "<center>[&nbsp;{0}&nbsp;]</center><br/>";
        String fileName = FileUtils.getHtmledFileName(path);
        String result = MessageFormat.format(form, fileName);
        return result;
    }

    private static void abortCantBuildDir(Path path) {
        String fileName = ConfigDirUi.getCenteredFileName(path);
        String msg = MessageFormat.format(FORM_MKDIRFAIL, fileName);
        ConfigDirUi.showErrorMessage(msg);
        ConfigDirUi.abort();
        assert (false);
    }

    private static void abortCantAccessDir(Path path) {
        String fileName = ConfigDirUi.getCenteredFileName(path);
        String msg = MessageFormat.format(FORM_ACCERR, fileName);
        ConfigDirUi.showErrorMessage(msg);
        ConfigDirUi.abort();
        assert (false);
    }

    private static void logMkdirErr(Path dirPath, Throwable cause) {
        String pathTxt = dirPath.toString();
        String msg = MessageFormat.format(LOG_MKDIRERR, pathTxt);
        LOGGER.log(Level.SEVERE, msg, cause);
    }

    private static void copyResource(String resource, Path dest) {
        block14: {
            try (InputStream ris = ResourceManager.getResourceAsStream(resource);){
                BufferedInputStream is = new BufferedInputStream(ris);
                Files.copy(is, dest, new CopyOption[0]);
            }
            catch (IOException | SecurityException e) {
                String destName = dest.toString();
                String logMsg = MessageFormat.format(LOG_CREATEERR, destName);
                LOGGER.log(Level.SEVERE, logMsg, e);
                String destHtml = ConfigDirUi.getCenteredFileName(dest);
                String diagMsg = MessageFormat.format(FORM_WRITEERR, destHtml);
                ConfigDirUi.showErrorMessage(diagMsg);
                ConfigDirUi.abort();
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
        String destName = dest.toString();
        String msg = MessageFormat.format(LOG_RESCPY, destName);
        LOGGER.info(msg);
    }

    private static void checkDirPerm(Path confDir) {
        if (!FileUtils.isAccessibleDirectory(confDir)) {
            ConfigDirUi.abortCantAccessDir(confDir);
        }
    }

    public static void prepareConfigDir(ConfigStore configStore) {
        if (!configStore.useStoreFile()) {
            return;
        }
        Path conf = configStore.getConfigDir();
        if (Files.exists(conf, new LinkOption[0])) {
            ConfigDirUi.checkDirPerm(conf);
        } else {
            ConfigDirUi.buildConfDirPath(conf);
        }
        Path imgDir = configStore.getLocalImgDir();
        if (Files.exists(imgDir, new LinkOption[0])) {
            ConfigDirUi.checkDirPerm(imgDir);
        } else {
            ConfigDirUi.buildImageCacheDir(imgDir);
        }
    }

    private static Path buildConfDirPath(Path confPath) {
        block6: {
            assert (confPath.isAbsolute());
            if (Files.exists(confPath, new LinkOption[0])) {
                return confPath;
            }
            boolean confirmed = ConfigDirUi.confirmBuildConfigDir(confPath);
            if (!confirmed) {
                JOptionPane pane = new JOptionPane(MSG_ABORT, 2);
                ConfigDirUi.showDialog(pane);
                ConfigDirUi.abort();
                assert (false);
            }
            try {
                Files.createDirectories(confPath, new FileAttribute[0]);
            }
            catch (IOException | SecurityException e) {
                ConfigDirUi.logMkdirErr(confPath, e);
                ConfigDirUi.abortCantBuildDir(confPath);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        ConfigDirUi.checkDirPerm(confPath);
        Path readme = confPath.resolve(FILE_README);
        ConfigDirUi.copyResource(RES_README, readme);
        return confPath;
    }

    private static boolean confirmBuildConfigDir(Path confDir) {
        String confName = ConfigDirUi.getCenteredFileName(confDir);
        String msg = MessageFormat.format(FORM_MKCONF, confName);
        JOptionPane pane = new JOptionPane(msg, 3, 0);
        ConfigDirUi.showDialog(pane);
        Object val = pane.getValue();
        if (!(val instanceof Integer)) {
            return false;
        }
        int ival = (Integer)val;
        boolean result = ival == 0;
        return result;
    }

    private static void buildImageCacheDir(Path imgCacheDir) {
        block4: {
            assert (imgCacheDir.isAbsolute());
            if (Files.exists(imgCacheDir, new LinkOption[0])) {
                return;
            }
            try {
                Files.createDirectories(imgCacheDir, new FileAttribute[0]);
            }
            catch (IOException | SecurityException e) {
                ConfigDirUi.logMkdirErr(imgCacheDir, e);
                ConfigDirUi.abortCantBuildDir(imgCacheDir);
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        ConfigDirUi.checkDirPerm(imgCacheDir);
        Path jsonPath = imgCacheDir.resolve(FILE_AVATARJSON);
        ConfigDirUi.copyResource(RES_AVATARJSON, jsonPath);
    }

    public static void tryLock(ConfigStore configStore) {
        if (!configStore.useStoreFile()) {
            return;
        }
        Path lockPath = configStore.getLockFile();
        File lockFile = lockPath.toFile();
        InterVMLock lock = new InterVMLock(lockFile);
        lock.tryLock();
        if (!lock.isFileOwner()) {
            ConfigDirUi.confirmLockError(lock);
            if (!lock.isFileOwner()) {
                configStore.setNoConf();
            }
        }
    }

    private static void confirmLockError(InterVMLock lock) {
        File lockFile = lock.getLockFile();
        LockErrorPane lockPane = new LockErrorPane(lockFile.toPath());
        JDialog lockDialog = lockPane.createDialog(TITLE_BUILDCONF);
        lockDialog.setResizable(true);
        lockDialog.pack();
        do {
            boolean windowClosed;
            lockDialog.setVisible(true);
            Object result = lockPane.getValue();
            boolean aborted = LockErrorPane.isAborted(result);
            boolean bl = windowClosed = result == null;
            if (aborted || windowClosed) {
                ConfigDirUi.abort();
                assert (false);
                break;
            }
            if (lockPane.isRadioRetry()) {
                lock.tryLock();
                continue;
            }
            if (lockPane.isRadioContinue()) {
                JOptionPane pane = new JOptionPane(MSG_NOCONF, 1);
                ConfigDirUi.showDialog(pane);
                break;
            }
            if (!lockPane.isRadioForce()) continue;
            ConfigDirUi.forceRemove(lock);
            break;
        } while (!lock.isFileOwner());
        lockDialog.dispose();
    }

    private static void forceRemove(InterVMLock lock) {
        File lockFile = lock.getLockFile();
        lock.forceRemove();
        if (lock.isExistsFile()) {
            String fileName = ConfigDirUi.getCenteredFileName(lockFile.toPath());
            String msg = MessageFormat.format(FORM_FAILRM, fileName);
            ConfigDirUi.showErrorMessage(msg);
            ConfigDirUi.abort();
            assert (false);
            return;
        }
        lock.tryLock();
        if (lock.isFileOwner()) {
            return;
        }
        String fileName = ConfigDirUi.getCenteredFileName(lockFile.toPath());
        String msg = MessageFormat.format(FORM_ILLLOCK, fileName);
        ConfigDirUi.showErrorMessage(msg);
        ConfigDirUi.abort();
        assert (false);
    }
}

