/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import jp.sfjp.jindolf.config.FileUtils;

public class ConfigStore {
    private static final Path JINCONF = Paths.get("Jindolf", new String[0]);
    private static final Path JINCONF_DOT = Paths.get(".jindolf", new String[0]);
    private static final Path LOCKFILE = Paths.get("lock", new String[0]);
    private static final Path LOCALIMG_DIR = Paths.get("img", new String[0]);
    private static final Path MAC_LIB = Paths.get("Library", new String[0]);
    private static final Path MAC_APPSUPP = Paths.get("Application Support", new String[0]);
    private boolean useStoreFile;
    private Path configDir;

    public ConfigStore() {
        this(false, null);
    }

    public ConfigStore(Path configDirPath) throws IllegalArgumentException {
        this(true, configDirPath);
    }

    protected ConfigStore(boolean useStoreFile, Path configDirPath) throws IllegalArgumentException {
        this.useStoreFile = useStoreFile;
        if (this.useStoreFile) {
            if (configDirPath != null) {
                if (!configDirPath.isAbsolute()) {
                    throw new IllegalArgumentException();
                }
                this.configDir = configDirPath;
            } else {
                this.configDir = ConfigStore.getDefaultConfDirPath();
            }
        } else {
            this.configDir = null;
        }
        assert (this.useStoreFile && this.configDir != null || !this.useStoreFile && this.configDir == null);
    }

    public static Path getDefaultConfDirPath() {
        Path confPath;
        Path jarParent = FileUtils.getJarDirectory();
        if (FileUtils.isAccessibleDirectory(jarParent) && FileUtils.isAccessibleDirectory(confPath = jarParent.resolve(JINCONF))) {
            assert (confPath.isAbsolute());
            return confPath;
        }
        Path appset = ConfigStore.getAppSetDir();
        Path leaf = FileUtils.isMacOSXFs() || FileUtils.isWindowsOSFs() ? JINCONF : JINCONF_DOT;
        Path result = appset.resolve(leaf);
        assert (result.isAbsolute());
        return result;
    }

    private static Path getAppSetDir() {
        Path home;
        Path result = home = ConfigStore.getHomeDirectory();
        if (FileUtils.isMacOSXFs()) {
            result = result.resolve(MAC_LIB);
            result = result.resolve(MAC_APPSUPP);
        }
        return result;
    }

    private static Path getHomeDirectory() {
        String homeProp = System.getProperty("user.home");
        Path result = Paths.get(homeProp, new String[0]);
        result = result.toAbsolutePath();
        return result;
    }

    public boolean useStoreFile() {
        return this.useStoreFile;
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    public void setNoConf() {
        this.useStoreFile = false;
        this.configDir = null;
    }

    public Path getLocalImgDir() {
        if (!this.useStoreFile) {
            return null;
        }
        if (this.configDir == null) {
            return null;
        }
        Path result = this.configDir.resolve(LOCALIMG_DIR);
        assert (result.isAbsolute());
        return result;
    }

    public Path getLockFile() {
        if (!this.useStoreFile) {
            return null;
        }
        if (this.configDir == null) {
            return null;
        }
        Path lockFile = this.configDir.resolve(LOCKFILE);
        return lockFile;
    }
}

