/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public final class EnvInfo {
    public static final String OS_NAME;
    public static final String OS_VERSION;
    public static final String OS_ARCH;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VERSION;
    public static final long MAX_MEMORY;
    private static final SortedMap<String, String> PROPERTY_MAP;
    private static final SortedMap<String, String> ENVIRONMENT_MAP;
    private static final List<String> CLASSPATHS;
    private static final String[] PROPNAMES;
    private static final String[] ENVNAMES;
    private static final String FORM_MEM = "\u6700\u5927\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u91cf: {0,number} bytes\n";
    private static final String INDENT = "  ";
    private static final char NL = '\n';

    private EnvInfo() {
        assert (false);
    }

    private static SortedMap<String, String> buildEnvMap() {
        TreeMap<String, String> envmap = new TreeMap<String, String>();
        for (String name : ENVNAMES) {
            String val;
            try {
                val = System.getenv(name);
            }
            catch (SecurityException e) {
                continue;
            }
            if (val == null) continue;
            envmap.put(name, val);
        }
        SortedMap<String, String> result = Collections.unmodifiableSortedMap(envmap);
        return result;
    }

    private static SortedMap<String, String> buildPropMap() {
        TreeMap<String, String> propmap = new TreeMap<String, String>();
        for (String name : PROPNAMES) {
            String val;
            try {
                val = System.getProperty(name);
            }
            catch (SecurityException e) {
                continue;
            }
            if (val == null) continue;
            propmap.put(name, val);
        }
        SortedMap<String, String> result = Collections.unmodifiableSortedMap(propmap);
        return result;
    }

    private static List<String> buildClassPathList(String classpath) {
        String[] pathArray = classpath != null ? classpath.split(File.pathSeparator) : new String[]{};
        List<String> result = Arrays.asList(pathArray);
        result = Collections.unmodifiableList(result);
        return result;
    }

    public static String getVMInfo() {
        StringBuilder result = new StringBuilder();
        String memform = MessageFormat.format(FORM_MEM, MAX_MEMORY);
        result.append(memform).append('\n');
        result.append(EnvInfo.getSysPropInfo()).append('\n');
        result.append(EnvInfo.getEnvInfo()).append('\n');
        result.append(EnvInfo.getClassPathInfo()).append('\n');
        return result.toString();
    }

    private static CharSequence getSysPropInfo() {
        StringBuilder result = new StringBuilder();
        result.append("\u4e3b\u8981\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3:\n");
        PROPERTY_MAP.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("java.class.path")).forEachOrdered(entry -> {
            result.append(INDENT);
            result.append((String)entry.getKey());
            result.append('=');
            result.append((String)entry.getValue());
            result.append('\n');
        });
        return result;
    }

    private static CharSequence getEnvInfo() {
        StringBuilder result = new StringBuilder("\u4e3b\u8981\u74b0\u5883\u5909\u6570:\n");
        ENVIRONMENT_MAP.entrySet().stream().forEachOrdered(entry -> {
            result.append(INDENT);
            result.append((String)entry.getKey());
            result.append('=');
            result.append((String)entry.getValue());
            result.append('\n');
        });
        return result;
    }

    private static CharSequence getClassPathInfo() {
        StringBuilder result = new StringBuilder("\u30af\u30e9\u30b9\u30d1\u30b9:\n");
        CLASSPATHS.stream().forEachOrdered(path -> result.append(INDENT).append((String)path).append('\n'));
        return result;
    }

    static {
        PROPNAMES = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version", "java.class.path"};
        ENVNAMES = new String[]{"LANG", "DISPLAY"};
        Runtime runtime = Runtime.getRuntime();
        MAX_MEMORY = runtime.maxMemory();
        ENVIRONMENT_MAP = EnvInfo.buildEnvMap();
        PROPERTY_MAP = EnvInfo.buildPropMap();
        OS_NAME = (String)PROPERTY_MAP.get("os.name");
        OS_VERSION = (String)PROPERTY_MAP.get("os.version");
        OS_ARCH = (String)PROPERTY_MAP.get("os.arch");
        JAVA_VENDOR = (String)PROPERTY_MAP.get("java.vendor");
        JAVA_VERSION = (String)PROPERTY_MAP.get("java.version");
        String classpath = (String)PROPERTY_MAP.get("java.class.path");
        CLASSPATHS = EnvInfo.buildClassPathList(classpath);
    }
}

