/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Locale;

public final class FileUtils {
    private static final Class<?> THISKLASS = FileUtils.class;
    private static final String LANG_JA = "ja";
    private static final String SYSPROP_OSNAME = "os.name";
    private static final String SCHEME_FILE = "file";
    private static final String ENTITY_YEN = "&yen;";

    private FileUtils() {
        assert (this.getClass() == THISKLASS);
    }

    public static boolean isAccessibleDirectory(Path path) {
        if (path == null) {
            return false;
        }
        boolean result = Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path) && Files.isWritable(path);
        return result;
    }

    public static URL getClassSourceUrl(Class<?> klass) {
        ProtectionDomain domain = klass.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource src = domain.getCodeSource();
        if (src == null) {
            return null;
        }
        URL location = src.getLocation();
        return location;
    }

    public static Path getClassSourcePath(Class<?> klass) {
        URI uri;
        URL location = FileUtils.getClassSourceUrl(klass);
        if (location == null) {
            return null;
        }
        String scheme = location.getProtocol();
        if (!SCHEME_FILE.equalsIgnoreCase(scheme)) {
            return null;
        }
        try {
            uri = location.toURI();
        }
        catch (URISyntaxException e) {
            assert (false);
            return null;
        }
        Path result = Paths.get(uri);
        result = result.toAbsolutePath();
        return result;
    }

    public static boolean isExistsJarFile(Path path) {
        if (path == null) {
            return false;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        Path leaf = path.getFileName();
        assert (leaf != null);
        String leafName = leaf.toString();
        boolean result = leafName.matches("^.+\\.[jJ][aA][rR]$");
        return result;
    }

    public static Path getJarDirectory(Class<?> klass) {
        Path jarFile = FileUtils.getClassSourcePath(klass);
        if (jarFile == null) {
            return null;
        }
        if (!FileUtils.isExistsJarFile(jarFile)) {
            return null;
        }
        Path result = jarFile.getParent();
        assert (result.isAbsolute());
        return result;
    }

    public static Path getJarDirectory() {
        return FileUtils.getJarDirectory(THISKLASS);
    }

    public static boolean isMacOSXFs() {
        if (File.separatorChar != '/') {
            return false;
        }
        String osName = System.getProperty(SYSPROP_OSNAME);
        if (osName == null) {
            return false;
        }
        osName = osName.toLowerCase(Locale.ROOT);
        boolean result = osName.startsWith("mac os x");
        return result;
    }

    public static boolean isWindowsOSFs() {
        if (File.separatorChar != '\\') {
            return false;
        }
        String osName = System.getProperty(SYSPROP_OSNAME);
        if (osName == null) {
            return false;
        }
        osName = osName.toLowerCase(Locale.ROOT);
        boolean result = osName.startsWith("windows");
        return result;
    }

    public static String getHtmledFileName(Path path) {
        String pathName = path.toString();
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        if (FileUtils.isWindowsOSFs() && lang.equals(LANG_JA)) {
            pathName = pathName.replace(File.separator, ENTITY_YEN);
        }
        return "<code>" + pathName + "</code>";
    }

    static {
        assert (!FileUtils.isMacOSXFs() || !FileUtils.isWindowsOSFs());
        new FileUtils().hashCode();
    }
}

