/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sourceforge.jovsonz.JsComposition;
import jp.sourceforge.jovsonz.JsObject;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.Json;

public class JsonIo {
    public static final Path HIST_FILE = Paths.get("searchHistory.json", new String[0]);
    public static final Path NETCONFIG_FILE = Paths.get("netconfig.json", new String[0]);
    public static final Path TALKCONFIG_FILE = Paths.get("talkconfig.json", new String[0]);
    public static final Path LOCALIMGCONFIG_PATH = Paths.get("avatarCache.json", new String[0]);
    private static final Charset CHARSET_JSON = StandardCharsets.UTF_8;
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final ConfigStore configStore;

    public JsonIo(ConfigStore configStore) {
        Objects.nonNull(configStore);
        this.configStore = configStore;
    }

    public JsObject loadJsObject(Path file) {
        if (!this.configStore.useStoreFile()) {
            return null;
        }
        JsComposition<?> root = this.loadJson(file);
        if (root == null || root.getJsTypes() != JsTypes.OBJECT) {
            return null;
        }
        JsObject result = (JsObject)root;
        return result;
    }

    protected JsComposition<?> loadJson(Path file) {
        JsComposition<?> root;
        Path absFile;
        if (file.isAbsolute()) {
            absFile = file;
        } else {
            Path configDir = this.configStore.getConfigDir();
            if (configDir == null) {
                return null;
            }
            absFile = configDir.resolve(file);
            if (!Files.exists(absFile, new LinkOption[0])) {
                return null;
            }
            if (!absFile.isAbsolute()) {
                return null;
            }
        }
        String absPath = absFile.toString();
        try (InputStream is = Files.newInputStream(absFile, new OpenOption[0]);){
            BufferedInputStream bis = new BufferedInputStream(is);
            root = this.loadJson(bis);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u8aad\u307f\u8fbc\u307f\u6642\u306b\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            return null;
        }
        catch (JsParseException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u5185\u5bb9\u306b\u4e0d\u5099\u304c\u3042\u308a\u307e\u3059\u3002", e);
            return null;
        }
        return root;
    }

    protected JsComposition<?> loadJson(InputStream is) throws IOException, JsParseException {
        Reader reader = new InputStreamReader(is, CHARSET_JSON);
        reader = new BufferedReader(reader);
        JsComposition<?> root = this.loadJson(reader);
        return root;
    }

    protected JsComposition<?> loadJson(Reader reader) throws IOException, JsParseException {
        JsComposition<?> root = Json.parseJson(reader);
        return root;
    }

    public boolean saveJson(Path file, JsComposition<?> root) {
        if (!this.configStore.useStoreFile()) {
            return false;
        }
        Path configDir = this.configStore.getConfigDir();
        Path absFile = configDir.resolve(file);
        String absPath = absFile.toString();
        try {
            Files.deleteIfExists(absFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.createFile(absFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u65b0\u898f\u751f\u6210\u304c\u3067\u304d\u307e\u305b\u3093\u3002", e);
            return false;
        }
        try (OutputStream os = Files.newOutputStream(absFile, new OpenOption[0]);){
            BufferedOutputStream bos = new BufferedOutputStream(os);
            this.saveJson(bos, root);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u66f8\u304d\u8fbc\u307f\u6642\u306b\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            return false;
        }
        catch (JsVisitException e) {
            LOGGER.log(Level.SEVERE, "JSON\u30d5\u30a1\u30a4\u30eb[" + absPath + "]\u306e\u51fa\u529b\u51e6\u7406\u3067\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            return false;
        }
        return true;
    }

    protected void saveJson(OutputStream os, JsComposition<?> root) throws IOException, JsVisitException {
        Writer writer = new OutputStreamWriter(os, CHARSET_JSON);
        writer = new BufferedWriter(writer);
        this.saveJson(writer, root);
    }

    protected void saveJson(Writer writer, JsComposition<?> root) throws IOException, JsVisitException {
        Json.dumpJson(writer, root);
    }

    public JsObject loadHistoryConfig() {
        JsObject result = this.loadJsObject(HIST_FILE);
        return result;
    }

    public JsObject loadNetConfig() {
        JsObject result = this.loadJsObject(NETCONFIG_FILE);
        return result;
    }

    public JsObject loadTalkConfig() {
        JsObject result = this.loadJsObject(TALKCONFIG_FILE);
        return result;
    }

    public JsObject loadLocalImgConfig() {
        if (!this.configStore.useStoreFile()) {
            return null;
        }
        Path imgDir = this.configStore.getLocalImgDir();
        Path path = imgDir.resolve(LOCALIMGCONFIG_PATH);
        JsObject result = this.loadJsObject(path);
        return result;
    }

    public boolean saveHistoryConfig(JsComposition<?> root) {
        boolean result = this.saveJson(HIST_FILE, root);
        return result;
    }

    public boolean saveNetConfig(JsComposition<?> root) {
        boolean result = this.saveJson(NETCONFIG_FILE, root);
        return result;
    }

    public boolean saveTalkConfig(JsComposition<?> root) {
        boolean result = this.saveJson(TALKCONFIG_FILE, root);
        return result;
    }
}

