/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sfjp.jindolf.config.CmdOption;

public class OptionInfo {
    private static final String REGEX_DIMNO = "([1-9][0-9]{0,5})";
    private static final String REGEX_SIGN = "(?:\\+|(\\-))";
    private static final String REGEX_LOCNO = "(?:\\+|(\\-))([1-9][0-9]{0,5})";
    private static final String REGEX_GEOMETRY = "([1-9][0-9]{0,5})x([1-9][0-9]{0,5})(?:(?:\\+|(\\-))([1-9][0-9]{0,5})(?:\\+|(\\-))([1-9][0-9]{0,5}))?";
    private static final Pattern PATTERN_GEOMETRY = Pattern.compile("([1-9][0-9]{0,5})x([1-9][0-9]{0,5})(?:(?:\\+|(\\-))([1-9][0-9]{0,5})(?:\\+|(\\-))([1-9][0-9]{0,5}))?");
    private static final String ERRFORM_UKNOWN = "\u672a\u5b9a\u7fa9\u306e\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[{0}]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
    private static final String ERRFORM_NOARG = "\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[{0}]\u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    private static final String ERRFORM_GEOM = "\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[{0}]\u306e\u30b8\u30aa\u30e1\u30c8\u30ea\u6307\u5b9a[{1}]\u304c\u4e0d\u6b63\u3067\u3059\u3002WIDTHxHEIGHT[(+|-)XPOS(+|-)YPOS]\u306e\u5f62\u5f0f\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
    private static final String ERRFORM_BOOL = "\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[{0}]\u306e\u771f\u507d\u6307\u5b9a[{1}]\u304c\u4e0d\u6b63\u3067\u3059\u3002on, off, yes, no, true, false\u306e\u3044\u305a\u308c\u304b\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final String ERRFORM_NONBOOL = "\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[{0}]\u306f\u771f\u507d\u3092\u6307\u5b9a\u3059\u308b\u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002";
    private Integer frameWidth = null;
    private Integer frameHeight = null;
    private Integer frameXpos = null;
    private Integer frameYpos = null;
    private final List<String> invokeArgs = new LinkedList<String>();
    private final List<CmdOption> optionList = new LinkedList<CmdOption>();
    private final Map<CmdOption, Boolean> boolOptionMap = new EnumMap<CmdOption, Boolean>(CmdOption.class);
    private final Map<CmdOption, String> stringOptionMap = new EnumMap<CmdOption, String>(CmdOption.class);

    protected OptionInfo() {
    }

    private static boolean equalsIgnoreCase(String text, String ... names) {
        for (String name : names) {
            if (!text.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static void parseBooleanSwitch(OptionInfo info, CmdOption option, String optTxt, String onoff) throws IllegalArgumentException {
        Boolean flag;
        if (OptionInfo.equalsIgnoreCase(onoff, "on", "yes", "true")) {
            flag = Boolean.TRUE;
        } else if (OptionInfo.equalsIgnoreCase(onoff, "off", "no", "false")) {
            flag = Boolean.FALSE;
        } else {
            String errmsg = MessageFormat.format(ERRFORM_BOOL, optTxt, onoff);
            throw new IllegalArgumentException(errmsg);
        }
        info.boolOptionMap.put(option, flag);
    }

    private static void parseGeometry(OptionInfo info, String optTxt, String geometry) throws IllegalArgumentException {
        Matcher matcher = PATTERN_GEOMETRY.matcher(geometry);
        if (!matcher.matches()) {
            String errmsg = MessageFormat.format(ERRFORM_GEOM, optTxt, geometry);
            throw new IllegalArgumentException(errmsg);
        }
        int gpos = 1;
        String width = matcher.group(gpos++);
        String height = matcher.group(gpos++);
        String xMinus = matcher.group(gpos++);
        String xPos = matcher.group(gpos++);
        String yMinus = matcher.group(gpos++);
        String yPos = matcher.group(gpos++);
        info.frameWidth = Integer.parseInt(width);
        info.frameHeight = Integer.parseInt(height);
        if (xPos != null) {
            info.frameXpos = Integer.parseInt(xPos);
            if (xMinus != null) {
                info.frameXpos = -info.frameXpos.intValue();
            }
        }
        if (yPos != null) {
            info.frameYpos = Integer.parseInt(yPos);
            if (yMinus != null) {
                info.frameYpos = -info.frameYpos.intValue();
            }
        }
    }

    private static void parseOptionArg(OptionInfo info, String optTxt, CmdOption option, Iterator<String> iterator) throws IllegalArgumentException {
        if (!iterator.hasNext()) {
            String errMsg = MessageFormat.format(ERRFORM_NOARG, optTxt);
            throw new IllegalArgumentException(errMsg);
        }
        String nextArg = iterator.next();
        if (option == CmdOption.OPT_GEOMETRY) {
            OptionInfo.parseGeometry(info, optTxt, nextArg);
        } else if (option.isBooleanOption()) {
            OptionInfo.parseBooleanSwitch(info, option, optTxt, nextArg);
        } else if (option == CmdOption.OPT_INITFONT || option == CmdOption.OPT_CONFDIR) {
            info.stringOptionMap.put(option, nextArg);
        } else assert (false);
    }

    public static OptionInfo parseOptions(String ... args) throws IllegalArgumentException {
        OptionInfo result = new OptionInfo();
        for (String arg : args) {
            if (arg == null) continue;
            result.invokeArgs.add(arg);
        }
        Iterator<String> iterator = result.invokeArgs.iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            CmdOption option = CmdOption.parseCmdOption(arg);
            if (option == null) {
                String errmsg = MessageFormat.format(ERRFORM_UKNOWN, arg);
                throw new IllegalArgumentException(errmsg);
            }
            result.optionList.add(option);
            if (option.isIndepOption()) continue;
            OptionInfo.parseOptionArg(result, arg, option, iterator);
        }
        return result;
    }

    public List<String> getInvokeArgList() {
        return Collections.unmodifiableList(this.invokeArgs);
    }

    public boolean hasOption(CmdOption option) {
        boolean result = this.optionList.contains((Object)option);
        return result;
    }

    public Boolean getBooleanArg(CmdOption option) throws IllegalArgumentException {
        if (!option.isBooleanOption()) {
            String errMsg = MessageFormat.format(ERRFORM_NONBOOL, option.toString());
            throw new IllegalArgumentException(errMsg);
        }
        Boolean result = this.boolOptionMap.get((Object)option);
        return result;
    }

    public String getStringArg(CmdOption option) {
        String result = this.stringOptionMap.get((Object)option);
        return result;
    }

    public CmdOption getExclusiveOption(CmdOption ... options) {
        CmdOption result = null;
        block0: for (CmdOption option : this.optionList) {
            for (CmdOption excOption : options) {
                if (option != excOption) continue;
                result = option;
                continue block0;
            }
        }
        return result;
    }

    public Integer initialFrameWidth() {
        return this.frameWidth;
    }

    public Integer initialFrameHeight() {
        return this.frameHeight;
    }

    public Integer initialFrameXpos() {
        return this.frameXpos;
    }

    public Integer initialFrameYpos() {
        return this.frameYpos;
    }
}

