/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.stream.Collectors;
import jp.sfjp.jindolf.data.CoreData;
import jp.sourceforge.jindolf.corelib.PreDefAvatar;

public class Avatar
implements Comparable<Avatar> {
    public static final Avatar AVATAR_GERD;
    private static final List<Avatar> AVATAR_LIST;
    private static final Map<String, Avatar> AVATAR_FN_MAP;
    private static final Map<String, Avatar> AVATAR_ID_MAP;
    private final String name;
    private final String jobTitle;
    private final String fullName;
    private final int idNum;
    private final String identifier;

    private Avatar(String name, String jobTitle, int idNum, String identifier) {
        this.name = name.intern();
        this.jobTitle = jobTitle.intern();
        this.idNum = idNum;
        this.identifier = identifier.intern();
        this.fullName = (this.jobTitle + " " + this.name).intern();
    }

    private static List<Avatar> buildAvatarList() {
        List<PreDefAvatar> predefs = CoreData.getPreDefAvatarList();
        List<Avatar> result = predefs.stream().map(preDefAvatar -> Avatar.toAvatar(preDefAvatar)).sorted().collect(Collectors.toList());
        result = Collections.unmodifiableList(result);
        return result;
    }

    private static Avatar toAvatar(PreDefAvatar pre) {
        String shortName = pre.getShortName();
        String jobTitle = pre.getJobTitle();
        int serialNo = pre.getSerialNo();
        String avatarId = pre.getAvatarId();
        Avatar result = new Avatar(shortName, jobTitle, serialNo, avatarId);
        return result;
    }

    public static List<Avatar> getPredefinedAvatarList() {
        return AVATAR_LIST;
    }

    public static Avatar getAvatarByFullname(String fullNameArg) {
        return AVATAR_FN_MAP.get(fullNameArg);
    }

    public static Avatar getAvatarById(String avatarId) {
        return AVATAR_ID_MAP.get(avatarId);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getName() {
        return this.name;
    }

    public int getIdNum() {
        return this.idNum;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public int compareTo(Avatar avatar) {
        if (avatar == null) {
            return 1;
        }
        return this.idNum - avatar.idNum;
    }

    static {
        AVATAR_LIST = Avatar.buildAvatarList();
        AVATAR_FN_MAP = new HashMap<String, Avatar>();
        AVATAR_ID_MAP = new HashMap<String, Avatar>();
        AVATAR_LIST.forEach(avatar -> {
            String fullName = avatar.getFullName();
            String avatarId = avatar.getIdentifier();
            AVATAR_FN_MAP.put(fullName, (Avatar)avatar);
            AVATAR_ID_MAP.put(avatarId, (Avatar)avatar);
        });
        AVATAR_GERD = Avatar.getAvatarById("gerd");
        assert (AVATAR_LIST instanceof RandomAccess);
        assert (AVATAR_GERD != null);
    }
}

