/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.net.ServerAccess;
import jp.sourceforge.jindolf.corelib.LandDef;

public class Land {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final LandDef landDef;
    private final ServerAccess serverAccess;
    private final List<Village> villageList = new ArrayList<Village>(1000);

    public Land(LandDef landDef) throws IllegalArgumentException {
        URL url;
        this.landDef = landDef;
        try {
            url = this.landDef.getCgiURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.serverAccess = new ServerAccess(url, this.landDef.getEncoding());
    }

    public LandDef getLandDef() {
        return this.landDef;
    }

    public ServerAccess getServerAccess() {
        return this.serverAccess;
    }

    public Village getVillage(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getVillageCount()) {
            return null;
        }
        Village result = this.villageList.get(index);
        return result;
    }

    public int getVillageCount() {
        int result = this.villageList.size();
        return result;
    }

    public List<Village> getVillageList() {
        return Collections.unmodifiableList(this.villageList);
    }

    public BufferedImage downloadImage(String imageURL) {
        BufferedImage image;
        ServerAccess server = this.getServerAccess();
        try {
            image = server.downloadImage(imageURL);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "\u30a4\u30e1\u30fc\u30b8[" + imageURL + "]\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            return null;
        }
        return image;
    }

    public BufferedImage getGraveIconImage() {
        URI uri = this.getLandDef().getTombFaceIconURI();
        BufferedImage result = this.downloadImage(uri.toASCIIString());
        return result;
    }

    public BufferedImage getGraveBodyImage() {
        URI uri = this.getLandDef().getTombBodyIconURI();
        BufferedImage result = this.downloadImage(uri.toASCIIString());
        return result;
    }

    public void updateVillageList(List<Village> vset) {
        this.villageList.clear();
        this.villageList.addAll(vset);
    }

    public String toString() {
        return this.getLandDef().getLandName();
    }
}

