/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jp.sfjp.jindolf.data.CoreData;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Village;
import jp.sourceforge.jindolf.corelib.LandDef;

public class LandsTreeModel
implements TreeModel {
    private static final Object ROOT = new Object();
    private static final int SECTION_INTERVAL = 100;
    private final EventListenerList listeners = new EventListenerList();
    private final List<Land> landList = LandsTreeModel.buildLandList();
    private final Map<Land, List<VillageSection>> sectionMap = new HashMap<Land, List<VillageSection>>();
    private boolean ascending = false;

    private static boolean isRoot(Object obj) {
        boolean result = Objects.equals(ROOT, obj);
        return result;
    }

    private static List<Land> buildLandList() {
        List<LandDef> landDefList = CoreData.getLandDefList();
        ArrayList newList = new ArrayList(landDefList.size());
        landDefList.stream().map(landDef -> new Land((LandDef)landDef)).forEachOrdered(land -> newList.add(land));
        return Collections.unmodifiableList(newList);
    }

    private static List<VillageSection> getSectionList(Land land, int interval) throws IllegalArgumentException {
        if (interval <= 0) {
            throw new IllegalArgumentException();
        }
        String pfx = land.getLandDef().getLandPrefix();
        ArrayList<Village> span = new ArrayList<Village>(interval);
        ArrayList<VillageSection> result = new ArrayList<VillageSection>(2500 / interval);
        boolean loop1st = true;
        int rangeStart = -1;
        int rangeEnd = -1;
        for (Village village : land.getVillageList()) {
            int vid = village.getVillageIDNum();
            if (loop1st) {
                rangeStart = vid / interval * interval;
                rangeEnd = rangeStart + interval - 1;
                loop1st = false;
            }
            if (rangeEnd < vid) {
                VillageSection section = new VillageSection(pfx, rangeStart, rangeEnd, span);
                span.clear();
                result.add(section);
                rangeStart = vid / interval * interval;
                rangeEnd = rangeStart + interval - 1;
            }
            span.add(village);
        }
        if (!span.isEmpty()) {
            VillageSection section = new VillageSection(pfx, rangeStart, rangeEnd, span);
            span.clear();
            result.add(section);
        }
        return result;
    }

    public List<Land> getLandList() {
        return this.landList;
    }

    public void updateVillageList(Land land) {
        List<VillageSection> sectionList = LandsTreeModel.getSectionList(land, 100);
        this.sectionMap.put(land, sectionList);
        int[] childIndices = new int[sectionList.size()];
        for (int ct = 0; ct < childIndices.length; ++ct) {
            childIndices[ct] = ct;
        }
        Object[] children = sectionList.toArray();
        TreePath treePath = new TreePath(ROOT);
        treePath = treePath.pathByAddingChild(land);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeStructureChanged(event);
    }

    public void setAscending(boolean ascending) {
        if (this.ascending == ascending) {
            return;
        }
        this.ascending = ascending;
        this.fireLandListChanged();
    }

    @Override
    public void addTreeModelListener(TreeModelListener lst) {
        this.listeners.add(TreeModelListener.class, lst);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener lst) {
        this.listeners.remove(TreeModelListener.class, lst);
    }

    private TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    protected void fireTreeStructureChanged(TreeModelEvent event) {
        for (TreeModelListener listener : this.getTreeModelListeners()) {
            listener.treeStructureChanged(event);
        }
    }

    private void fireLandListChanged() {
        int size = this.getLandList().size();
        int[] childIndices = new int[size];
        for (int ct = 0; ct < size; ++ct) {
            int index;
            childIndices[ct] = index = ct;
        }
        Object[] children = this.getLandList().toArray();
        TreePath treePath = new TreePath(ROOT);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeStructureChanged(event);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getChildCount(parent)) {
            return null;
        }
        Object result = null;
        if (LandsTreeModel.isRoot(parent)) {
            List<Land> list = this.getLandList();
            int landIndex = index;
            if (!this.ascending) {
                landIndex = list.size() - index - 1;
            }
            Land land = list.get(landIndex);
            result = land;
        } else if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            int sectIndex = index;
            if (!this.ascending) {
                sectIndex = sectionList.size() - index - 1;
            }
            VillageSection section = sectionList.get(sectIndex);
            result = section;
        } else if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            int vilIndex = index;
            if (!this.ascending) {
                vilIndex = section.getVillageCount() - index - 1;
            }
            Village village = section.getVillage(vilIndex);
            result = village;
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {
        int result = 0;
        if (LandsTreeModel.isRoot(parent)) {
            result = this.getLandList().size();
        } else if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            if (sectionList != null) {
                result = sectionList.size();
            }
        } else if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            result = section.getVillageCount();
        }
        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child == null) {
            return -1;
        }
        int result = -1;
        if (LandsTreeModel.isRoot(parent)) {
            List<Land> list = this.getLandList();
            int index = list.indexOf(child);
            if (!this.ascending) {
                index = list.size() - index - 1;
            }
            result = index;
        } else if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            int index = sectionList.indexOf(child);
            if (!this.ascending) {
                index = sectionList.size() - index - 1;
            }
            result = index;
        } else if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            int index = section.getIndexOfVillage(child);
            if (!this.ascending) {
                index = section.getVillageCount() - index - 1;
            }
            result = index;
        }
        return result;
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof Village) {
            return true;
        }
        if (node instanceof VillageSection) {
            return false;
        }
        if (node instanceof Land) {
            return false;
        }
        return !LandsTreeModel.isRoot(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static final class VillageSection {
        private static final String FORM_NODE = "{0}{1,number,#} \uff5e {0}{2,number,#}";
        private static final String FORM_NODE_G = "{0}{1,number,#000} \uff5e {0}{2,number,#000}";
        private final int startId;
        private final int endId;
        private final String text;
        private final List<Village> villageList;

        VillageSection(String prefix, int startId, int endId, List<Village> spanList) throws IndexOutOfBoundsException {
            if (startId < 0 || startId > endId) {
                throw new IndexOutOfBoundsException();
            }
            this.startId = startId;
            this.endId = endId;
            String format = "G".equals(prefix) ? FORM_NODE_G : FORM_NODE;
            this.text = MessageFormat.format(format, prefix, this.startId, this.endId);
            ArrayList<Village> newList = new ArrayList<Village>(spanList);
            this.villageList = Collections.unmodifiableList(newList);
            assert (this.endId - this.startId + 1 >= this.villageList.size());
        }

        int getVillageCount() {
            return this.villageList.size();
        }

        Village getVillage(int index) {
            return this.villageList.get(index);
        }

        int getIndexOfVillage(Object child) {
            return this.villageList.indexOf(child);
        }

        public String toString() {
            return this.text;
        }
    }
}

