/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.SysEvent;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.data.Village;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.SysEventType;

public final class Period {
    private final Village homeVillage;
    private final PeriodType periodType;
    private final int day;
    private int limitHour;
    private int limitMinute;
    private final List<Topic> topicList = new LinkedList<Topic>();
    private final List<Topic> unmodList = Collections.unmodifiableList(this.topicList);

    public Period(Village homeVillage, PeriodType periodType, int day) {
        Objects.nonNull(homeVillage);
        Objects.nonNull((Object)periodType);
        if (day < 0) {
            throw new IllegalArgumentException("Period day is too small !");
        }
        switch (periodType) {
            case PROLOGUE: {
                assert (day == 0);
                break;
            }
            case PROGRESS: 
            case EPILOGUE: {
                assert (day > 0);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.homeVillage = homeVillage;
        this.periodType = periodType;
        this.day = day;
        this.unload();
    }

    public Village getVillage() {
        return this.homeVillage;
    }

    public PeriodType getType() {
        return this.periodType;
    }

    public int getDay() {
        return this.day;
    }

    public void setLimit(int hour, int minute) {
        this.limitHour = hour;
        this.limitMinute = minute;
    }

    public String getLimit() {
        StringBuilder result = new StringBuilder();
        if (this.limitHour < 10) {
            result.append('0');
        }
        result.append(this.limitHour).append(':');
        if (this.limitMinute < 10) {
            result.append('0');
        }
        result.append(this.limitMinute);
        return result.toString();
    }

    public boolean isPrologue() {
        return this.getType() == PeriodType.PROLOGUE;
    }

    public boolean isEpilogue() {
        return this.getType() == PeriodType.EPILOGUE;
    }

    public boolean isProgress() {
        return this.getType() == PeriodType.PROGRESS;
    }

    public String getCGIQuery() {
        StringBuilder result = new StringBuilder();
        Village village = this.getVillage();
        result.append(village.getCGIQuery());
        Land land = village.getParentLand();
        LandDef ldef = land.getLandDef();
        if (ldef.getLandId().equals("wolfg")) {
            result.append("&meslog=");
            String dnum = "000" + (this.getDay() - 1);
            dnum = dnum.substring(dnum.length() - 3);
            switch (this.getType()) {
                case PROLOGUE: {
                    result.append("000_ready");
                    break;
                }
                case PROGRESS: {
                    result.append(dnum).append("_progress");
                    break;
                }
                case EPILOGUE: {
                    result.append(dnum).append("_party");
                    break;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
        } else {
            result.append("&meslog=").append(village.getVillageID());
            switch (this.getType()) {
                case PROLOGUE: {
                    result.append("_ready_0");
                    break;
                }
                case PROGRESS: {
                    result.append("_progress_").append(this.getDay() - 1);
                    break;
                }
                case EPILOGUE: {
                    result.append("_party_").append(this.getDay() - 1);
                    break;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
        }
        result.append("&mes=all");
        return result.toString();
    }

    public List<Topic> getTopicList() {
        return this.unmodList;
    }

    public void clearTopicList() {
        this.topicList.clear();
    }

    public int getTopics() {
        return this.topicList.size();
    }

    public void addTopic(Topic topic) throws NullPointerException {
        if (topic == null) {
            throw new NullPointerException();
        }
        this.topicList.add(topic);
    }

    public String getCaption() {
        String result;
        switch (this.getType()) {
            case PROLOGUE: {
                result = "\u30d7\u30ed\u30ed\u30fc\u30b0";
                break;
            }
            case PROGRESS: {
                result = this.getDay() + "\u65e5\u76ee";
                break;
            }
            case EPILOGUE: {
                result = "\u30a8\u30d4\u30ed\u30fc\u30b0";
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    public Talk getNumberedTalk(int talkNo) {
        if (talkNo <= 0) {
            throw new IllegalArgumentException();
        }
        for (Topic topic : this.topicList) {
            Talk talk;
            if (!(topic instanceof Talk) || talkNo != (talk = (Talk)topic).getTalkNo()) continue;
            return talk;
        }
        return null;
    }

    public boolean hasLoaded() {
        return !this.topicList.isEmpty();
    }

    public void unload() {
        this.limitHour = 0;
        this.limitMinute = 0;
        this.topicList.clear();
    }

    public boolean hasAssaultTried() {
        for (Topic topic : this.topicList) {
            SysEvent sysEvent;
            SysEventType type;
            Talk talk;
            if (!(topic instanceof Talk ? (talk = (Talk)topic).getTalkCount() <= 0 : topic instanceof SysEvent && (type = (sysEvent = (SysEvent)topic).getSysEventType()) == SysEventType.ASSAULT)) continue;
            return true;
        }
        return false;
    }

    public Avatar getExecutedAvatar() {
        Avatar result = null;
        for (Topic topic : this.getTopicList()) {
            SysEvent event;
            if (topic instanceof SysEvent && (result = (event = (SysEvent)topic).getExecutedAvatar()) != null) break;
        }
        return result;
    }

    public Set<Avatar> getVoterSet() {
        Set<Avatar> result = new HashSet<Avatar>();
        for (Topic topic : this.getTopicList()) {
            if (!(topic instanceof SysEvent)) continue;
            SysEvent event = (SysEvent)topic;
            result = event.getVoterSet(result);
        }
        return result;
    }

    public SysEvent getTypedSysEvent(SysEventType type) {
        for (Topic topic : this.getTopicList()) {
            SysEvent event;
            if (!(topic instanceof SysEvent) || (event = (SysEvent)topic).getSysEventType() != type) continue;
            return event;
        }
        return null;
    }
}

