/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.InterPlay;
import jp.sfjp.jindolf.data.Nominated;
import jp.sfjp.jindolf.data.Player;
import jp.sfjp.jindolf.data.Topic;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.SysEventType;

public class SysEvent
implements Topic {
    private EventFamily eventFamily;
    private SysEventType sysEventType;
    private DecodedContent content;
    private final List<Avatar> avatarList = new LinkedList<Avatar>();
    private final List<GameRole> roleList = new LinkedList<GameRole>();
    private final List<Integer> integerList = new LinkedList<Integer>();
    private final List<CharSequence> charseqList = new LinkedList<CharSequence>();
    private final List<Player> playerList = new LinkedList<Player>();
    private final List<Nominated> nominatedList = new LinkedList<Nominated>();
    private final List<InterPlay> interPlayList = new LinkedList<InterPlay>();

    public EventFamily getEventFamily() {
        return this.eventFamily;
    }

    public void setEventFamily(EventFamily eventFamily) throws NullPointerException {
        this.eventFamily = eventFamily;
    }

    public SysEventType getSysEventType() {
        return this.sysEventType;
    }

    public void setSysEventType(SysEventType type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException();
        }
        this.sysEventType = type;
    }

    public DecodedContent getContent() {
        return this.content;
    }

    public void setContent(DecodedContent content) throws NullPointerException {
        if (content == null) {
            throw new NullPointerException();
        }
        this.content = content;
    }

    public List<Avatar> getAvatarList() {
        List<Avatar> result = Collections.unmodifiableList(this.avatarList);
        return result;
    }

    public List<GameRole> getRoleList() {
        List<GameRole> result = Collections.unmodifiableList(this.roleList);
        return result;
    }

    public List<Integer> getIntegerList() {
        List<Integer> result = Collections.unmodifiableList(this.integerList);
        return result;
    }

    public List<CharSequence> getCharSequenceList() {
        List<CharSequence> result = Collections.unmodifiableList(this.charseqList);
        return result;
    }

    public List<Player> getPlayerList() {
        List<Player> result = Collections.unmodifiableList(this.playerList);
        return result;
    }

    public List<Nominated> getNominatedList() {
        List<Nominated> result = Collections.unmodifiableList(this.nominatedList);
        return result;
    }

    public List<InterPlay> getInterPlayList() {
        List<InterPlay> result = Collections.unmodifiableList(this.interPlayList);
        return result;
    }

    public void addAvatarList(List<Avatar> list) {
        this.avatarList.addAll(list);
    }

    public void addRoleList(List<GameRole> list) {
        this.roleList.addAll(list);
    }

    public void addIntegerList(List<Integer> list) {
        this.integerList.addAll(list);
    }

    public void addCharSequenceList(List<CharSequence> list) {
        this.charseqList.addAll(list);
    }

    public void addPlayerList(List<Player> list) {
        this.playerList.addAll(list);
    }

    public void addNominatedList(List<Nominated> list) {
        this.nominatedList.addAll(list);
    }

    public void addInterPlayList(List<InterPlay> list) {
        this.interPlayList.addAll(list);
    }

    public Avatar getExecutedAvatar() {
        Avatar result = null;
        switch (this.sysEventType) {
            case COUNTING: 
            case EXECUTION: {
                if (this.avatarList.isEmpty()) break;
                result = this.avatarList.get(0);
                break;
            }
            case COUNTING2: {
                break;
            }
        }
        return result;
    }

    public Set<Avatar> getVoterSet(Set<Avatar> set) {
        Set<Avatar> result = set == null ? new HashSet<Avatar>() : set;
        if (this.sysEventType != SysEventType.COUNTING && this.sysEventType != SysEventType.COUNTING2) {
            return result;
        }
        Set voterSet = this.interPlayList.stream().map(interPlay -> interPlay.getByWhom()).collect(Collectors.toSet());
        result.addAll(voterSet);
        return result;
    }
}

