/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Topic;
import jp.sourceforge.jindolf.corelib.TalkType;

public class Talk
implements Topic {
    private static final String MEINICHI_LAST = "\uff01 \u4eca\u65e5\u304c\u304a\u524d\u306e\u547d\u65e5\u3060\uff01";
    private static final Map<TalkType, String> COLOR_MAP = new EnumMap<TalkType, String>(TalkType.class);
    private final Period homePeriod;
    private final TalkType talkType;
    private final Avatar avatar;
    private final String messageID;
    private final int hour;
    private final int minute;
    private int charNum;
    private int talkNo;
    private CharSequence dialog;
    private int count = -1;

    public Talk(Period homePeriod, TalkType talkType, Avatar avatar, int talkNo, String messageID, int hour, int minute, CharSequence dialog) {
        if (homePeriod == null || talkType == null || avatar == null || messageID == null || dialog == null) {
            throw new NullPointerException();
        }
        if (hour < 0 || 23 < hour) {
            throw new IllegalArgumentException();
        }
        if (minute < 0 || 59 < minute) {
            throw new IllegalArgumentException();
        }
        if (talkType != TalkType.PUBLIC && 0 < talkNo) {
            throw new IllegalArgumentException();
        }
        this.homePeriod = homePeriod;
        this.talkType = talkType;
        this.avatar = avatar;
        this.talkNo = talkNo;
        this.messageID = messageID;
        this.hour = hour;
        this.minute = minute;
        this.dialog = dialog;
        this.charNum = this.dialog.length();
    }

    public static String encodeColorName(TalkType type) {
        Objects.requireNonNull(type);
        String result = COLOR_MAP.get((Object)type);
        return result;
    }

    static boolean isTerminated(CharSequence target, CharSequence term) throws NullPointerException {
        Objects.requireNonNull(target);
        Objects.requireNonNull(term);
        int targetLength = target.length();
        int termLength = term.length();
        int offset = targetLength - termLength;
        if (offset < 0) {
            return false;
        }
        for (int pos = 0; pos < termLength; ++pos) {
            char termch;
            char targetch = target.charAt(offset + pos);
            if (targetch == (termch = term.charAt(0 + pos))) continue;
            return false;
        }
        return true;
    }

    public Period getPeriod() {
        return this.homePeriod;
    }

    public TalkType getTalkType() {
        return this.talkType;
    }

    public boolean isGrave() {
        return this.talkType == TalkType.GRAVE;
    }

    public int getTalkCount() {
        return this.count;
    }

    public int getTotalChars() {
        return this.charNum;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public int getTalkNo() {
        return this.talkNo;
    }

    public void setTalkNo(int talkNo) {
        this.talkNo = talkNo;
    }

    public boolean hasTalkNo() {
        return 0 < this.talkNo;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public long getTimeFromID() {
        String epoch = this.messageID.replace("mes", "");
        long result = Long.parseLong(epoch) * 1000L;
        return result;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public CharSequence getDialog() {
        return this.dialog;
    }

    public void setDialog(CharSequence seq) {
        this.dialog = seq;
        this.charNum = this.dialog.length();
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getAnchorNotation() {
        int day = this.homePeriod.getDay();
        String hstr = "0" + this.hour;
        hstr = hstr.substring(hstr.length() - 2);
        String mstr = "0" + this.minute;
        mstr = mstr.substring(mstr.length() - 2);
        return day + "d" + hstr + ":" + mstr;
    }

    public String getAnchorNotation_G() {
        if (!this.hasTalkNo()) {
            return "";
        }
        return ">>" + this.talkNo;
    }

    public boolean isMurderNotice() {
        boolean isWolf;
        boolean bl = isWolf = this.talkType == TalkType.WOLFONLY;
        if (!isWolf) {
            return false;
        }
        boolean meinichida = Talk.isTerminated(this.getDialog(), MEINICHI_LAST);
        return meinichida;
    }

    public String toString() {
        String verb;
        String fullName = this.avatar.getFullName();
        switch (this.talkType) {
            case PUBLIC: {
                verb = " says ";
                break;
            }
            case PRIVATE: {
                verb = " think ";
                break;
            }
            case WOLFONLY: {
                verb = " howl ";
                break;
            }
            case GRAVE: {
                verb = " groan ";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(fullName).append(verb).append(this.dialog);
        return result.toString();
    }

    static {
        COLOR_MAP.put(TalkType.PUBLIC, "\u767d");
        COLOR_MAP.put(TalkType.PRIVATE, "\u7070");
        COLOR_MAP.put(TalkType.WOLFONLY, "\u8d64");
        COLOR_MAP.put(TalkType.GRAVE, "\u9752");
    }
}

