/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sfjp.jindolf.data.Anchor;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.view.AvatarPics;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.VillageState;

public class Village {
    private static final int GID_MIN = 3;
    private final Land parentLand;
    private final String villageID;
    private final int villageIDNum;
    private final String villageName;
    private final boolean isValid;
    private int limitMonth;
    private int limitDay;
    private int limitHour;
    private int limitMinute;
    private VillageState state = VillageState.UNKNOWN;
    private final LinkedList<Period> periodList = new LinkedList();
    private final List<Period> unmodList = Collections.unmodifiableList(this.periodList);
    private final Map<String, Avatar> avatarMap = new HashMap<String, Avatar>();
    private final AvatarPics avatarPics;
    private boolean isLocalArchive = false;

    public Village(Land parentLand, String villageID, String villageName) {
        this.parentLand = parentLand;
        this.villageID = villageID.intern();
        this.villageIDNum = Integer.parseInt(this.villageID);
        this.villageName = villageName.intern();
        this.isValid = this.parentLand.getLandDef().isValidVillageId(this.villageIDNum);
        this.avatarPics = new AvatarPics(this.parentLand);
    }

    public Land getParentLand() {
        return this.parentLand;
    }

    public String getVillageID() {
        return this.villageID;
    }

    public int getVillageIDNum() {
        return this.villageIDNum;
    }

    public String getVillageName() {
        StringBuilder name = new StringBuilder();
        LandDef landDef = this.parentLand.getLandDef();
        String prefix = landDef.getLandPrefix();
        name.append(prefix);
        StringBuilder id = new StringBuilder(this.villageID);
        if (landDef.getLandId().equals("wolfg")) {
            while (id.length() < 3) {
                id.insert(0, '0');
            }
        }
        name.append((CharSequence)id);
        String result = name.toString();
        return result;
    }

    public String getVillageFullName() {
        return this.villageName;
    }

    public VillageState getState() {
        return this.state;
    }

    public void setState(VillageState state) {
        this.state = state;
    }

    public boolean hasSchedule() {
        boolean result = !this.periodList.isEmpty();
        return result;
    }

    public Period getPrologue() {
        for (Period period : this.periodList) {
            if (!period.isPrologue()) continue;
            return period;
        }
        return null;
    }

    public Period getEpilogue() {
        for (Period period : this.periodList) {
            if (!period.isEpilogue()) continue;
            return period;
        }
        return null;
    }

    public Period getProgress(int day) {
        for (Period period : this.periodList) {
            if (!period.isProgress() || period.getDay() != day) continue;
            return period;
        }
        return null;
    }

    public int getProgressDays() {
        int result = 0;
        for (Period period : this.periodList) {
            if (!period.isProgress()) continue;
            ++result;
        }
        return result;
    }

    public Period getPeriod(int day) {
        return this.periodList.get(day);
    }

    public Period getPeriod(Anchor anchor) {
        if (anchor.isEpilogueDay()) {
            Period anchorPeriod = this.getEpilogue();
            return anchorPeriod;
        }
        int anchorDay = anchor.getDay();
        Period anchorPeriod = this.getPeriod(anchorDay);
        return anchorPeriod;
    }

    public int getPeriodSize() {
        return this.periodList.size();
    }

    public List<Period> getPeriodList() {
        return this.unmodList;
    }

    public Avatar getAvatar(String fullName) {
        Avatar avatar = this.avatarMap.get(fullName);
        return avatar;
    }

    public void addAvatar(Avatar avatar) {
        if (avatar == null) {
            return;
        }
        String fullName = avatar.getFullName();
        if (this.avatarMap.get(fullName) != null) {
            return;
        }
        this.avatarMap.put(fullName, avatar);
    }

    public AvatarPics getAvatarPics() {
        return this.avatarPics;
    }

    public String getCGIQuery() {
        StringBuilder result = new StringBuilder();
        result.append("?vid=").append(this.getVillageID());
        return result.toString();
    }

    public void setLimit(int month, int day, int hour, int minute) {
        this.limitMonth = month;
        this.limitDay = day;
        this.limitHour = hour;
        this.limitMinute = minute;
    }

    public int getLimitMonth() {
        return this.limitMonth;
    }

    public int getLimitDay() {
        return this.limitDay;
    }

    public int getLimitHour() {
        return this.limitHour;
    }

    public int getLimitMinute() {
        return this.limitMinute;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setPeriod(int index, Period period) throws IndexOutOfBoundsException {
        int listSize = this.periodList.size();
        if (index == listSize) {
            this.periodList.add(period);
        } else if (index < listSize) {
            this.periodList.set(index, period);
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public List<Talk> getTalkListFromAnchor(Anchor anchor) {
        LinkedList<Talk> result = new LinkedList<Talk>();
        if (anchor.hasTalkNo()) {
            for (Period period : this.periodList) {
                Talk talk = period.getNumberedTalk(anchor.getTalkNo());
                if (talk == null) continue;
                result.add(talk);
            }
            return result;
        }
        Period anchorPeriod = this.getPeriod(anchor);
        if (anchorPeriod == null) {
            return result;
        }
        for (Topic topic : anchorPeriod.getTopicList()) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getHour() != anchor.getHour() || talk.getMinute() != anchor.getMinute()) continue;
            result.add(talk);
        }
        return result;
    }

    public void unloadPeriods() {
        for (Period period : this.periodList) {
            period.unload();
        }
    }

    public boolean isLocalArchive() {
        return this.isLocalArchive;
    }

    public void setLocalArchive(boolean flag) {
        this.isLocalArchive = flag;
    }

    public String toString() {
        return this.getVillageFullName();
    }
}

