/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.html;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.osdn.jindolf.parser.EntityConverter;
import jp.osdn.jindolf.parser.HtmlAdapter;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.PageType;
import jp.osdn.jindolf.parser.SeqRange;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.InterPlay;
import jp.sfjp.jindolf.data.Nominated;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Player;
import jp.sfjp.jindolf.data.SysEvent;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.data.Village;
import jp.sourceforge.jindolf.corelib.Destiny;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.TalkType;
import jp.sourceforge.jindolf.corelib.Team;

class PeriodHandler
extends HtmlAdapter {
    private static final int TALKTYPE_NUM = TalkType.values().length;
    private final EntityConverter converter = new EntityConverter(true);
    private final Map<Avatar, int[]> countMap = new HashMap<Avatar, int[]>();
    private Period period = null;
    private TalkType talkType;
    private Avatar avatar;
    private int talkNo;
    private String anchorId;
    private int talkHour;
    private int talkMinute;
    private DecodedContent talkContent = null;
    private EventFamily eventFamily;
    private SysEventType sysEventType;
    private DecodedContent eventContent = null;
    private final List<Avatar> avatarList = new LinkedList<Avatar>();
    private final List<GameRole> roleList = new LinkedList<GameRole>();
    private final List<Integer> integerList = new LinkedList<Integer>();
    private final List<CharSequence> charseqList = new LinkedList<CharSequence>();
    private final List<Player> playerList = new LinkedList<Player>();
    private final List<Nominated> nominatedList = new LinkedList<Nominated>();
    private final List<InterPlay> interPlayList = new LinkedList<InterPlay>();

    PeriodHandler() {
    }

    void setPeriod(Period period) {
        this.period = period;
        this.reset();
    }

    private Avatar toAvatar(DecodedContent content, SeqRange range) {
        String fullName;
        Village village = this.period.getVillage();
        Avatar result = village.getAvatar(fullName = this.converter.convert(content, range).toString());
        if (result == null) {
            result = Avatar.getAvatarByFullname(fullName);
            village.addAvatar(result);
        }
        return result;
    }

    void reset() {
        this.countMap.clear();
        this.resetTalkContext();
        this.resetEventContext();
    }

    private void resetTalkContext() {
        this.talkType = null;
        this.avatar = null;
        this.talkNo = -1;
        this.anchorId = null;
        this.talkHour = -1;
        this.talkMinute = -1;
        this.talkContent = null;
    }

    private void resetEventContext() {
        this.eventFamily = null;
        this.sysEventType = null;
        this.eventContent = null;
        this.avatarList.clear();
        this.roleList.clear();
        this.integerList.clear();
        this.charseqList.clear();
        this.playerList.clear();
        this.nominatedList.clear();
        this.interPlayList.clear();
    }

    @Override
    public void startParse(DecodedContent content) throws HtmlParseException {
        this.reset();
        this.period.clearTopicList();
    }

    @Override
    public void loginName(DecodedContent content, SeqRange loginRange) throws HtmlParseException {
    }

    @Override
    public void pageType(PageType type) throws HtmlParseException {
        if (type != PageType.PERIOD_PAGE) {
            throw new HtmlParseException("\u610f\u56f3\u3057\u306a\u3044\u30da\u30fc\u30b8\u3092\u8aad\u307f\u8fbc\u3082\u3046\u3068\u3057\u307e\u3057\u305f\u3002");
        }
    }

    @Override
    public void commitTime(int month, int day, int hour, int minute) throws HtmlParseException {
        this.period.setLimit(hour, minute);
    }

    @Override
    public void periodLink(DecodedContent content, SeqRange anchorRange, PeriodType periodType, int day) throws HtmlParseException {
        boolean dayMatch;
        if (this.period.getType() != periodType) {
            return;
        }
        boolean isProgress = periodType == PeriodType.PROGRESS;
        boolean bl = dayMatch = this.period.getDay() == day;
        if (isProgress && !dayMatch) {
            return;
        }
        if (!anchorRange.isValid()) {
            return;
        }
    }

    @Override
    public void startTalk() throws HtmlParseException {
        this.resetTalkContext();
        this.talkContent = new DecodedContent(101);
    }

    @Override
    public void talkType(TalkType type) throws HtmlParseException {
        this.talkType = type;
    }

    @Override
    public void talkAvatar(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        this.avatar = this.toAvatar(content, avatarRange);
    }

    @Override
    public void talkTime(int hour, int minute) throws HtmlParseException {
        this.talkHour = hour;
        this.talkMinute = minute;
    }

    @Override
    public void talkNo(int tno) throws HtmlParseException {
        this.talkNo = tno;
    }

    @Override
    public void talkId(DecodedContent content, SeqRange idRange) throws HtmlParseException {
        this.anchorId = content.subSequence(idRange.getStartPos(), idRange.getEndPos()).toString();
    }

    @Override
    public void talkText(DecodedContent content, SeqRange textRange) throws HtmlParseException {
        this.converter.append(this.talkContent, content, textRange);
    }

    @Override
    public void talkBreak() throws HtmlParseException {
        this.talkContent.append('\n');
    }

    private int countUp(Avatar targetAvatar, TalkType targetType) {
        int typeIdx;
        int[] avatarCount = this.countMap.get(targetAvatar);
        if (avatarCount == null) {
            avatarCount = new int[TALKTYPE_NUM];
            this.countMap.put(targetAvatar, avatarCount);
        }
        int n = typeIdx = targetType.ordinal();
        int n2 = avatarCount[n] + 1;
        avatarCount[n] = n2;
        int count = n2;
        return count;
    }

    @Override
    public void endTalk() throws HtmlParseException {
        Talk talk = new Talk(this.period, this.talkType, this.avatar, this.talkNo, this.anchorId, this.talkHour, this.talkMinute, this.talkContent);
        int count = this.countUp(this.avatar, this.talkType);
        talk.setCount(count);
        this.period.addTopic(talk);
        this.resetTalkContext();
    }

    @Override
    public void startSysEvent(EventFamily family) throws HtmlParseException {
        this.resetEventContext();
        this.eventFamily = family;
        this.eventContent = new DecodedContent();
    }

    @Override
    public void sysEventType(SysEventType type) throws HtmlParseException {
        this.sysEventType = type;
    }

    @Override
    public void sysEventContent(DecodedContent content, SeqRange contentRange) throws HtmlParseException {
        this.converter.append(this.eventContent, content, contentRange);
    }

    @Override
    public void sysEventContentAnchor(DecodedContent content, SeqRange anchorRange, SeqRange contentRange) throws HtmlParseException {
        this.converter.append(this.eventContent, content, contentRange);
    }

    @Override
    public void sysEventContentBreak() throws HtmlParseException {
        this.eventContent.append('\n');
    }

    @Override
    public void sysEventOnStage(DecodedContent content, int entryNo, SeqRange avatarRange) throws HtmlParseException {
        Avatar newAvatar = this.toAvatar(content, avatarRange);
        Player player = new Player();
        player.setAvatar(newAvatar);
        player.setEntryNo(entryNo);
        this.playerList.add(player);
    }

    @Override
    public void sysEventOpenRole(GameRole role, int num) throws HtmlParseException {
        this.roleList.add(role);
        this.integerList.add(num);
    }

    @Override
    public void sysEventMurdered(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        Avatar murdered = this.toAvatar(content, avatarRange);
        this.avatarList.add(murdered);
    }

    @Override
    public void sysEventSurvivor(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        Avatar survivor = this.toAvatar(content, avatarRange);
        this.avatarList.add(survivor);
    }

    @Override
    public void sysEventCounting(DecodedContent content, SeqRange voteByRange, SeqRange voteToRange) throws HtmlParseException {
        if (!voteByRange.isValid()) {
            Avatar victim = this.toAvatar(content, voteToRange);
            this.avatarList.add(victim);
            return;
        }
        Avatar voteBy = this.toAvatar(content, voteByRange);
        Avatar voteTo = this.toAvatar(content, voteToRange);
        InterPlay interPlay = new InterPlay(voteBy, voteTo);
        this.interPlayList.add(interPlay);
    }

    @Override
    public void sysEventCounting2(DecodedContent content, SeqRange voteByRange, SeqRange voteToRange) throws HtmlParseException {
        this.sysEventCounting(content, voteByRange, voteToRange);
    }

    @Override
    public void sysEventSuddenDeath(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        Avatar suddenDeath = this.toAvatar(content, avatarRange);
        this.avatarList.add(suddenDeath);
    }

    @Override
    public void sysEventCheckout(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        Avatar checkouted = this.toAvatar(content, avatarRange);
        this.avatarList.add(checkouted);
    }

    @Override
    public void sysEventVanish(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        Avatar vanished = this.toAvatar(content, avatarRange);
        this.avatarList.add(vanished);
    }

    @Override
    public void sysEventPlayerList(DecodedContent content, SeqRange avatarRange, SeqRange anchorRange, SeqRange loginRange, boolean isLiving, GameRole role) throws HtmlParseException {
        Avatar who = this.toAvatar(content, avatarRange);
        CharSequence anchor = anchorRange.isValid() ? this.converter.convert(content, anchorRange) : "";
        DecodedContent account = this.converter.convert(content, loginRange);
        Player player = new Player();
        player.setAvatar(who);
        player.setRole(role);
        player.setIdName(account.toString());
        player.setUrlText(anchor.toString());
        if (isLiving) {
            player.setObitDay(-1);
            player.setDestiny(Destiny.ALIVE);
        }
        this.playerList.add(player);
    }

    @Override
    public void sysEventExecution(DecodedContent content, SeqRange avatarRange, int votes) throws HtmlParseException {
        Avatar who = this.toAvatar(content, avatarRange);
        if (votes <= 0) {
            this.avatarList.add(who);
        } else {
            Nominated nominated = new Nominated(who, votes);
            this.nominatedList.add(nominated);
        }
    }

    @Override
    public void sysEventAskEntry(int hour, int minute, int minLimit, int maxLimit) throws HtmlParseException {
        this.integerList.add(hour * 60 + minute);
        this.integerList.add(minLimit);
        this.integerList.add(maxLimit);
    }

    @Override
    public void sysEventAskCommit(int hour, int minute) throws HtmlParseException {
        this.integerList.add(hour * 60 + minute);
    }

    @Override
    public void sysEventNoComment(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        Avatar noComAvatar = this.toAvatar(content, avatarRange);
        this.avatarList.add(noComAvatar);
    }

    @Override
    public void sysEventStayEpilogue(Team winner, int hour, int minute) throws HtmlParseException {
        GameRole role = null;
        switch (winner) {
            case VILLAGE: {
                role = GameRole.INNOCENT;
                break;
            }
            case WOLF: {
                role = GameRole.WOLF;
                break;
            }
            case HAMSTER: {
                role = GameRole.HAMSTER;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.roleList.add(role);
        this.integerList.add(hour * 60 + minute);
    }

    @Override
    public void sysEventGuard(DecodedContent content, SeqRange guardByRange, SeqRange guardToRange) throws HtmlParseException {
        Avatar guardBy = this.toAvatar(content, guardByRange);
        Avatar guardTo = this.toAvatar(content, guardToRange);
        InterPlay interPlay = new InterPlay(guardBy, guardTo);
        this.interPlayList.add(interPlay);
    }

    @Override
    public void sysEventJudge(DecodedContent content, SeqRange judgeByRange, SeqRange judgeToRange) throws HtmlParseException {
        Avatar judgeBy = this.toAvatar(content, judgeByRange);
        Avatar judgeTo = this.toAvatar(content, judgeToRange);
        InterPlay interPlay = new InterPlay(judgeBy, judgeTo);
        this.interPlayList.add(interPlay);
    }

    @Override
    public void endSysEvent() throws HtmlParseException {
        boolean isMurderResult;
        SysEvent event = new SysEvent();
        event.setEventFamily(this.eventFamily);
        event.setSysEventType(this.sysEventType);
        event.setContent(this.eventContent);
        event.addAvatarList(this.avatarList);
        event.addRoleList(this.roleList);
        event.addIntegerList(this.integerList);
        event.addCharSequenceList(this.charseqList);
        event.addPlayerList(this.playerList);
        event.addNominatedList(this.nominatedList);
        event.addInterPlayList(this.interPlayList);
        this.period.addTopic(event);
        boolean bl = isMurderResult = this.sysEventType == SysEventType.MURDERED || this.sysEventType == SysEventType.NOMURDER;
        if (isMurderResult) {
            for (Topic topic : this.period.getTopicList()) {
                Talk talk;
                if (!(topic instanceof Talk) || !(talk = (Talk)topic).isMurderNotice()) continue;
                talk.setCount(-1);
                this.countMap.clear();
                break;
            }
        }
        this.resetEventContext();
    }

    @Override
    public void endParse() throws HtmlParseException {
        this.reset();
    }
}

