/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.html;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.HtmlParser;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.data.html.PeriodHandler;
import jp.sfjp.jindolf.net.HtmlSequence;
import jp.sfjp.jindolf.net.ServerAccess;

public final class PeriodLoader {
    private static final Logger LOGGER = Logger.getAnonymousLogger();

    private PeriodLoader() {
        assert (false);
    }

    public static void parsePeriod(Period period, boolean force) throws IOException {
        if (!force && period.hasLoaded()) {
            return;
        }
        Village village = period.getVillage();
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        HtmlSequence html = server.getHTMLPeriod(period);
        DecodedContent content = html.getContent();
        period.clearTopicList();
        HtmlParser parser = new HtmlParser();
        PeriodHandler handler = new PeriodHandler();
        parser.setBasicHandler(handler);
        parser.setSysEventHandler(handler);
        parser.setTalkHandler(handler);
        handler.setPeriod(period);
        try {
            parser.parseAutomatic(content);
        }
        catch (HtmlParseException e) {
            LOGGER.log(Level.WARNING, "\u767a\u8a00\u62bd\u51fa\u306b\u5931\u6557", e);
        }
        parser.reset();
        handler.reset();
    }
}

