/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.html;

import java.util.logging.Logger;
import jp.osdn.jindolf.parser.HtmlAdapter;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.PageType;
import jp.osdn.jindolf.parser.SeqRange;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Village;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.LandState;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.VillageState;

class VillageInfoHandler
extends HtmlAdapter {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private Village village = null;
    private boolean hasPrologue;
    private boolean hasProgress;
    private boolean hasEpilogue;
    private boolean hasDone;
    private int maxProgress;

    VillageInfoHandler() {
    }

    void setVillage(Village village) {
        this.village = village;
        this.reset();
    }

    void reset() {
        this.hasPrologue = false;
        this.hasProgress = false;
        this.hasEpilogue = false;
        this.hasDone = false;
        this.maxProgress = 0;
    }

    private VillageState getVillageState() {
        VillageState result = VillageState.UNKNOWN;
        if (this.hasDone) {
            result = VillageState.GAMEOVER;
        } else if (this.hasEpilogue) {
            result = VillageState.EPILOGUE;
        } else if (this.hasProgress) {
            result = VillageState.PROGRESS;
        } else if (this.hasPrologue) {
            result = VillageState.PROLOGUE;
        }
        return result;
    }

    @Override
    public void startParse(DecodedContent content) throws HtmlParseException {
        this.reset();
    }

    @Override
    public void pageType(PageType type) throws HtmlParseException {
        if (type != PageType.PERIOD_PAGE) {
            throw new HtmlParseException("\u65e5\u30da\u30fc\u30b8\u304c\u5fc5\u8981\u3067\u3059\u3002");
        }
    }

    @Override
    public void commitTime(int month, int day, int hour, int minute) throws HtmlParseException {
        this.village.setLimit(month, day, hour, minute);
    }

    @Override
    public void periodLink(DecodedContent content, SeqRange anchorRange, PeriodType periodType, int day) throws HtmlParseException {
        if (periodType == null) {
            this.hasDone = true;
            return;
        }
        switch (periodType) {
            case PROLOGUE: {
                this.hasPrologue = true;
                break;
            }
            case PROGRESS: {
                this.hasProgress = true;
                this.maxProgress = day;
                break;
            }
            case EPILOGUE: {
                this.hasEpilogue = true;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void endParse() throws HtmlParseException {
        VillageState villageState = this.getVillageState();
        if (villageState == VillageState.UNKNOWN) {
            this.village.setState(villageState);
            LOGGER.warning("\u6751\u306e\u72b6\u6cc1\u3092\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093");
            return;
        }
        Land land = this.village.getParentLand();
        LandDef landDef = land.getLandDef();
        LandState landState = landDef.getLandState();
        if (landState != LandState.ACTIVE) {
            villageState = VillageState.GAMEOVER;
        }
        this.village.setState(villageState);
        this.modifyPeriodList();
    }

    private void modifyPeriodList() {
        Period lastPeriod = null;
        if (this.hasPrologue) {
            Period prologue = this.village.getPrologue();
            if (prologue == null) {
                lastPeriod = new Period(this.village, PeriodType.PROLOGUE, 0);
                this.village.setPeriod(0, lastPeriod);
            } else {
                lastPeriod = prologue;
            }
        }
        if (this.hasProgress) {
            for (int day = 1; day <= this.maxProgress; ++day) {
                Period progress = this.village.getProgress(day);
                if (progress == null) {
                    lastPeriod = new Period(this.village, PeriodType.PROGRESS, day);
                    this.village.setPeriod(day, lastPeriod);
                    continue;
                }
                lastPeriod = progress;
            }
        }
        if (this.hasEpilogue) {
            Period epilogue = this.village.getEpilogue();
            if (epilogue == null) {
                int epilogueDay = this.maxProgress + 1;
                lastPeriod = new Period(this.village, PeriodType.EPILOGUE, epilogueDay);
                this.village.setPeriod(epilogueDay, lastPeriod);
            } else {
                lastPeriod = epilogue;
            }
        }
        assert (this.village.getPeriodSize() > 0);
        assert (lastPeriod != null);
    }
}

