/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.html;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.HtmlParser;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.data.html.VillageInfoHandler;
import jp.sfjp.jindolf.net.HtmlSequence;
import jp.sfjp.jindolf.net.ServerAccess;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.LandState;

public final class VillageInfoLoader {
    private static final Logger LOGGER = Logger.getAnonymousLogger();

    private VillageInfoLoader() {
        assert (false);
    }

    private static DecodedContent loadVillageInfo(Village village) throws IOException {
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        LandDef landDef = land.getLandDef();
        LandState landState = landDef.getLandState();
        HtmlSequence html = landState == LandState.ACTIVE ? server.getHTMLBoneHead(village) : server.getHTMLVillage(village);
        DecodedContent content = html.getContent();
        return content;
    }

    public static void updateVillageInfo(Village village) throws IOException {
        DecodedContent content = VillageInfoLoader.loadVillageInfo(village);
        HtmlParser parser = new HtmlParser();
        VillageInfoHandler handler = new VillageInfoHandler();
        parser.setBasicHandler(handler);
        parser.setSysEventHandler(handler);
        parser.setTalkHandler(handler);
        handler.setVillage(village);
        try {
            parser.parseAutomatic(content);
        }
        catch (HtmlParseException e) {
            LOGGER.log(Level.WARNING, "\u6751\u306e\u72b6\u614b\u304c\u4e0d\u660e", e);
        }
        parser.reset();
        handler.reset();
    }
}

