/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.html;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.osdn.jindolf.parser.HtmlAdapter;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.PageType;
import jp.osdn.jindolf.parser.SeqRange;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.html.VillageRecord;
import jp.sourceforge.jindolf.corelib.VillageState;

class VillageListHandler
extends HtmlAdapter {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final String ERR_ILLEGALPAGE = "\u30c8\u30c3\u30d7\u30da\u30fc\u30b8\u304b\u6751\u4e00\u89a7\u30da\u30fc\u30b8\u304c\u5fc5\u8981\u3067\u3059\u3002";
    private static final String ERR_URI = "\u8a8d\u8b58\u3067\u304d\u306a\u3044URL[{0}]\u306b\u906d\u9047\u3057\u307e\u3057\u305f\u3002";
    private static final Pattern REG_VID = Pattern.compile("\\Qindex.rb?vid=\\E([1-9][0-9]*)\\Q&amp;\\E");
    private List<VillageRecord> villageRecords = new LinkedList<VillageRecord>();

    VillageListHandler() {
    }

    static String parseVidFromHref(CharSequence hrefValue) {
        Matcher matcher = REG_VID.matcher(hrefValue);
        boolean match = matcher.lookingAt();
        if (!match) {
            return null;
        }
        String result = matcher.group(1);
        assert (result.length() > 0);
        return result;
    }

    List<VillageRecord> getVillageRecords() {
        return this.villageRecords;
    }

    void reset() {
        this.villageRecords = new LinkedList<VillageRecord>();
    }

    @Override
    public void startParse(DecodedContent content) throws HtmlParseException {
        this.reset();
    }

    @Override
    public void pageType(PageType type) throws HtmlParseException {
        if (type != PageType.VILLAGELIST_PAGE && type != PageType.TOP_PAGE) {
            throw new HtmlParseException(ERR_ILLEGALPAGE);
        }
    }

    @Override
    public void villageRecord(DecodedContent content, SeqRange anchorRange, SeqRange villageRange, int hour, int minute, VillageState villageState) throws HtmlParseException {
        CharSequence href = anchorRange.sliceSequence(content);
        String villageID = VillageListHandler.parseVidFromHref(href);
        if (villageID == null) {
            LOGGER.log(Level.WARNING, ERR_URI, href);
            return;
        }
        CharSequence fullVillageName = villageRange.sliceSequence(content);
        VillageRecord record = new VillageRecord(villageID, fullVillageName.toString(), villageState);
        this.villageRecords.add(record);
    }
}

