/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.HtmlParser;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.data.html.VillageListHandler;
import jp.sfjp.jindolf.data.html.VillageRecord;
import jp.sfjp.jindolf.net.HtmlSequence;
import jp.sfjp.jindolf.net.ServerAccess;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.LandState;
import jp.sourceforge.jindolf.corelib.VillageState;

public final class VillageListLoader {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final String ID_VANILLAWOLF = "wolf";
    private static final List<VillageRecord> EMPTY_LIST = Collections.emptyList();

    private VillageListLoader() {
        assert (false);
    }

    public static List<Village> loadVillageList(Land land) throws IOException {
        SortedSet<VillageRecord> records = VillageListLoader.loadVillageRecords(land);
        LandDef landDef = land.getLandDef();
        LandState landState = landDef.getLandState();
        boolean isHistorical = landState == LandState.HISTORICAL;
        ArrayList<Village> result = new ArrayList(records.size());
        for (VillageRecord record : records) {
            String id = record.getVillageId();
            String fullVillageName = record.getFullVillageName();
            VillageState status = isHistorical ? VillageState.GAMEOVER : record.getVillageStatus();
            Village village = new Village(land, id, fullVillageName);
            village.setState(status);
            result.add(village);
        }
        result = Collections.unmodifiableList(result);
        return result;
    }

    private static SortedSet<VillageRecord> loadVillageRecords(Land land) throws IOException {
        HtmlSequence html;
        List<VillageRecord> recList;
        LandDef landDef = land.getLandDef();
        boolean isVanillaWolf = landDef.getLandId().equals(ID_VANILLAWOLF);
        LandState state = landDef.getLandState();
        boolean needTopPage = state.equals((Object)LandState.ACTIVE) || isVanillaWolf;
        boolean hasVillageList = !isVanillaWolf;
        ServerAccess server = land.getServerAccess();
        TreeSet<VillageRecord> result = new TreeSet<VillageRecord>();
        if (needTopPage) {
            recList = EMPTY_LIST;
            html = server.getHTMLTopPage();
            try {
                recList = VillageListLoader.parseVillageRecords(html);
            }
            catch (HtmlParseException e) {
                LOGGER.log(Level.WARNING, "\u30c8\u30c3\u30d7\u30da\u30fc\u30b8\u3092\u8a8d\u8b58\u3067\u304d\u306a\u3044", e);
            }
            result.addAll(recList);
        }
        if (hasVillageList) {
            recList = EMPTY_LIST;
            html = server.getHTMLLandList();
            try {
                recList = VillageListLoader.parseVillageRecords(html);
            }
            catch (HtmlParseException e) {
                LOGGER.log(Level.WARNING, "\u6751\u4e00\u89a7\u30da\u30fc\u30b8\u3092\u8a8d\u8b58\u3067\u304d\u306a\u3044", e);
            }
            result.addAll(recList);
        }
        return result;
    }

    private static List<VillageRecord> parseVillageRecords(HtmlSequence html) throws HtmlParseException {
        HtmlParser parser = new HtmlParser();
        VillageListHandler handler = new VillageListHandler();
        parser.setBasicHandler(handler);
        DecodedContent content = html.getContent();
        parser.parseAutomatic(content);
        List<VillageRecord> result = handler.getVillageRecords();
        parser.reset();
        handler.reset();
        return result;
    }
}

