/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.xml;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.jindolf.corelib.SysEventType;

public enum ElemTag {
    VILLAGE("village"),
    AVATARLIST("avatarList"),
    AVATAR("avatar"),
    AVATARREF("avatarRef"),
    PERIOD("period"),
    TALK("talk"),
    LI("li"),
    RAWDATA("rawdata"),
    STARTENTRY("startEntry", SysEventType.STARTENTRY),
    ONSTAGE("onStage", SysEventType.ONSTAGE),
    STARTMIRROR("startMirror", SysEventType.STARTMIRROR),
    OPENROLE("openRole", SysEventType.OPENROLE),
    MURDERED("murdered", SysEventType.MURDERED),
    STARTASSAULT("startAssault", SysEventType.STARTASSAULT),
    SURVIVOR("survivor", SysEventType.SURVIVOR),
    COUNTING("counting", SysEventType.COUNTING),
    SUDDENDEATH("suddenDeath", SysEventType.SUDDENDEATH),
    NOMURDER("noMurder", SysEventType.NOMURDER),
    WINVILLAGE("winVillage", SysEventType.WINVILLAGE),
    WINWOLF("winWolf", SysEventType.WINWOLF),
    WINHAMSTER("winHamster", SysEventType.WINHAMSTER),
    PLAYERLIST("playerList", SysEventType.PLAYERLIST),
    PANIC("panic", SysEventType.PANIC),
    EXECUTION("execution", SysEventType.EXECUTION),
    VANISH("vanish", SysEventType.VANISH),
    CHECKOUT("checkout", SysEventType.CHECKOUT),
    SHORTMEMBER("shortMember", SysEventType.SHORTMEMBER),
    ASKENTRY("askEntry", SysEventType.ASKENTRY),
    ASKCOMMIT("askCommit", SysEventType.ASKCOMMIT),
    NOCOMMENT("noComment", SysEventType.NOCOMMENT),
    STAYEPILOGUE("stayEpilogue", SysEventType.STAYEPILOGUE),
    GAMEOVER("gameOver", SysEventType.GAMEOVER),
    JUDGE("judge", SysEventType.JUDGE),
    GUARD("guard", SysEventType.GUARD),
    COUNTING2("counting2", SysEventType.COUNTING2),
    ASSAULT("assault", SysEventType.ASSAULT),
    ROLEHEADS("roleHeads"),
    VOTE("vote"),
    PLAYERINFO("playerInfo"),
    NOMINATED("nominated");

    private final String name;
    private final SysEventType sysEventType;

    private ElemTag(String name, SysEventType type) {
        this.name = name;
        this.sysEventType = type;
    }

    private ElemTag(String name) {
        this(name, null);
    }

    public static Map<String, ElemTag> getQNameMap(String pfx) {
        HashMap<String, ElemTag> result = new HashMap<String, ElemTag>();
        String lead = pfx.isEmpty() ? "" : pfx + ":";
        for (ElemTag tag : ElemTag.values()) {
            String key = lead + tag.name;
            key = key.intern();
            result.put(key, tag);
        }
        return result;
    }

    public boolean isSysEventTag() {
        return this.sysEventType != null;
    }

    public SysEventType getSystemEventType() {
        return this.sysEventType;
    }
}

