/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.CoreData;
import jp.sfjp.jindolf.data.InterPlay;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Nominated;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Player;
import jp.sfjp.jindolf.data.SysEvent;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.data.xml.ElemTag;
import jp.sfjp.jindolf.data.xml.XmlDecoder;
import jp.sourceforge.jindolf.corelib.Destiny;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.TalkType;
import jp.sourceforge.jindolf.corelib.VillageState;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class VillageHandler
implements ContentHandler {
    private static final String NS_JINARCHIVE = "http://jindolf.sourceforge.jp/xml/ns/501";
    private static final int TALKTYPE_NUM = TalkType.values().length;
    private String nsPfx;
    private Land land;
    private Village village;
    private Period period;
    private Talk talk;
    private int talkNo;
    private SysEvent sysEvent;
    private boolean inLine;
    private final StringBuilder content = new StringBuilder(250);
    private final Map<Avatar, int[]> countMap = new HashMap<Avatar, int[]>();
    private final Map<String, Avatar> idAvatarMap = new HashMap<String, Avatar>();
    private final List<Avatar> avatarList = new LinkedList<Avatar>();
    private final List<Player> playerList = new LinkedList<Player>();
    private final List<Nominated> nominatedList = new LinkedList<Nominated>();
    private final List<InterPlay> interPlayList = new LinkedList<InterPlay>();
    private Map<String, ElemTag> qNameMap = ElemTag.getQNameMap("");

    private static String attrValue(Attributes atts, String attrName) {
        String result = atts.getValue("", attrName);
        return result;
    }

    private ElemTag decodeElemTag(String uri, String localName, String qName) {
        ElemTag result = this.qNameMap.get(qName);
        return result;
    }

    public Village getVillage() {
        return this.village;
    }

    private void resetBefore() {
        this.idAvatarMap.clear();
        this.countMap.clear();
        this.content.setLength(0);
        this.avatarList.clear();
        this.playerList.clear();
        this.nominatedList.clear();
        this.interPlayList.clear();
        this.inLine = false;
    }

    private void resetAfter() {
        this.idAvatarMap.clear();
        this.countMap.clear();
        this.content.setLength(0);
        this.avatarList.clear();
        this.playerList.clear();
        this.nominatedList.clear();
        this.interPlayList.clear();
        this.nsPfx = null;
        this.land = null;
        this.period = null;
    }

    private void startVillage(Attributes atts) {
        String landId = VillageHandler.attrValue(atts, "landId");
        String vid = VillageHandler.attrValue(atts, "vid");
        String name = VillageHandler.attrValue(atts, "fullName");
        String state = VillageHandler.attrValue(atts, "state");
        this.land = CoreData.getLandDefList().stream().filter(landDef -> landDef.getLandId().equals(landId)).map(landDef -> new Land((LandDef)landDef)).findFirst().get();
        this.village = new Village(this.land, vid, name);
        this.village.setState(VillageState.GAMEOVER);
        this.talkNo = 0;
        this.period = null;
    }

    private void startAvatar(Attributes atts) {
        String avatarId = VillageHandler.attrValue(atts, "avatarId");
        String fullName = VillageHandler.attrValue(atts, "fullName");
        String shortName = VillageHandler.attrValue(atts, "shortName");
        String faceIconUri = VillageHandler.attrValue(atts, "faceIconURI");
        Avatar avatar = Avatar.getAvatarByFullname(fullName);
        this.village.addAvatar(avatar);
        this.idAvatarMap.put(avatarId, avatar);
    }

    private void startPeriod(Attributes atts) throws SAXException {
        String typeAttr = VillageHandler.attrValue(atts, "type");
        String dayAttr = VillageHandler.attrValue(atts, "day");
        PeriodType periodType = XmlDecoder.decodePeriodType(typeAttr);
        int day = Integer.parseInt(dayAttr);
        this.period = new Period(this.village, periodType, day);
        int periodIdx = this.village.getPeriodSize();
        this.village.setPeriod(periodIdx, this.period);
    }

    private void endPeriod() {
        this.countMap.clear();
    }

    private int countUp(Avatar targetAvatar, TalkType targetType) {
        int typeIdx;
        int[] avatarCount = this.countMap.get(targetAvatar);
        if (avatarCount == null) {
            avatarCount = new int[TALKTYPE_NUM];
            this.countMap.put(targetAvatar, avatarCount);
        }
        int n = typeIdx = targetType.ordinal();
        int n2 = avatarCount[n] + 1;
        avatarCount[n] = n2;
        int count = n2;
        return count;
    }

    private void startTalk(Attributes atts) throws SAXException {
        String type = VillageHandler.attrValue(atts, "type");
        String avatarId = VillageHandler.attrValue(atts, "avatarId");
        String xname = VillageHandler.attrValue(atts, "xname");
        String time = VillageHandler.attrValue(atts, "time");
        TalkType talkType = XmlDecoder.decodeTalkType(type);
        Avatar talkAvatar = this.idAvatarMap.get(avatarId);
        int hour = XmlDecoder.decodeHour(time);
        int minute = XmlDecoder.decodeMinute(time);
        this.talk = new Talk(this.period, talkType, talkAvatar, 0, xname, hour, minute, "");
        int count = this.countUp(talkAvatar, talkType);
        this.talk.setCount(count);
        this.content.setLength(0);
    }

    private void endTalk() {
        int no = 0;
        if (this.talk.getTalkType() == TalkType.PUBLIC) {
            no = ++this.talkNo;
        }
        String dialog = this.content.toString();
        this.content.setLength(0);
        this.talk.setTalkNo(no);
        this.talk.setDialog(dialog);
        this.period.addTopic(this.talk);
    }

    private void startLi(Attributes atts) {
        this.inLine = true;
        if (this.content.length() > 0) {
            this.content.append('\n');
        }
    }

    private void endLi() {
        this.inLine = false;
    }

    private void startPlayerList(Attributes atts) {
        this.playerList.clear();
    }

    private void endPlayerList() {
        this.sysEvent.addPlayerList(this.playerList);
        this.playerList.clear();
    }

    private void startExecution(Attributes atts) {
        String victimId = VillageHandler.attrValue(atts, "victim");
        if (victimId != null) {
            Avatar victim = this.idAvatarMap.get(victimId);
            List<Avatar> single = Collections.singletonList(victim);
            this.sysEvent.addAvatarList(single);
        }
    }

    private void endExecution() {
        this.sysEvent.addNominatedList(this.nominatedList);
        this.nominatedList.clear();
    }

    private void endCounting() {
        this.sysEvent.addInterPlayList(this.interPlayList);
        this.interPlayList.clear();
    }

    private void endCounting2() {
        this.endCounting();
    }

    private void endMurdered() {
        this.sysEvent.addAvatarList(this.avatarList);
        this.avatarList.clear();
    }

    private void endSurvivor() {
        this.sysEvent.addAvatarList(this.avatarList);
        this.avatarList.clear();
    }

    private void startSuddenDeath(Attributes atts) {
        this.startSimpleAvatarAttr(atts);
    }

    private void startVanish(Attributes atts) {
        this.startSimpleAvatarAttr(atts);
    }

    private void startCheckOut(Attributes atts) {
        this.startSimpleAvatarAttr(atts);
    }

    private void startSimpleAvatarAttr(Attributes atts) {
        String avatarId = VillageHandler.attrValue(atts, "avatarId");
        Avatar avatar = this.idAvatarMap.get(avatarId);
        List<Avatar> single = Collections.singletonList(avatar);
        this.sysEvent.addAvatarList(single);
    }

    private void startCounting(Attributes atts) {
        String victimId = VillageHandler.attrValue(atts, "victim");
        if (victimId == null) {
            return;
        }
        Avatar victim = this.idAvatarMap.get(victimId);
        List<Avatar> single = Collections.singletonList(victim);
        this.sysEvent.addAvatarList(single);
    }

    private void startJudge(Attributes atts) {
        this.startSimpleInterPlay(atts);
    }

    private void startGuard(Attributes atts) {
        this.startSimpleInterPlay(atts);
    }

    private void startSimpleInterPlay(Attributes atts) {
        String byWhomId = VillageHandler.attrValue(atts, "byWhom");
        String targetId = VillageHandler.attrValue(atts, "target");
        Avatar byWhom = this.idAvatarMap.get(byWhomId);
        Avatar target = this.idAvatarMap.get(targetId);
        InterPlay interPlay = new InterPlay(byWhom, target);
        List<InterPlay> single = Collections.singletonList(interPlay);
        this.sysEvent.addInterPlayList(single);
    }

    private void startSysEvent(ElemTag tag, Attributes atts) {
        this.sysEvent = new SysEvent();
        SysEventType type = tag.getSystemEventType();
        EventFamily eventFamily = type.getEventFamily();
        this.sysEvent.setSysEventType(type);
        this.sysEvent.setEventFamily(eventFamily);
        if (this.sysEvent.getSysEventType() == SysEventType.ASSAULT) {
            this.startAssault(atts);
        } else {
            switch (tag) {
                case ONSTAGE: {
                    this.startOnStage(atts);
                    break;
                }
                case PLAYERLIST: {
                    this.startPlayerList(atts);
                    break;
                }
                case EXECUTION: {
                    this.startExecution(atts);
                    break;
                }
                case SUDDENDEATH: {
                    this.startSuddenDeath(atts);
                    break;
                }
                case COUNTING: {
                    this.startCounting(atts);
                    break;
                }
                case JUDGE: {
                    this.startJudge(atts);
                    break;
                }
                case GUARD: {
                    this.startGuard(atts);
                    break;
                }
                case VANISH: {
                    this.startVanish(atts);
                    break;
                }
                case CHECKOUT: {
                    this.startCheckOut(atts);
                    break;
                }
            }
        }
        this.content.setLength(0);
    }

    private void endSysEvent() {
        Topic topic;
        SysEventType eventType = this.sysEvent.getSysEventType();
        if (eventType == SysEventType.ASSAULT) {
            this.endAssault();
            topic = this.talk;
        } else {
            switch (eventType) {
                case PLAYERLIST: {
                    this.endPlayerList();
                    break;
                }
                case EXECUTION: {
                    this.endExecution();
                    break;
                }
                case COUNTING: {
                    this.endCounting();
                    break;
                }
                case COUNTING2: {
                    this.endCounting2();
                    break;
                }
                case MURDERED: {
                    this.endMurdered();
                    break;
                }
                case SURVIVOR: {
                    this.endSurvivor();
                    break;
                }
            }
            DecodedContent decoded = new DecodedContent(this.content);
            this.sysEvent.setContent(decoded);
            topic = this.sysEvent;
        }
        this.period.addTopic(topic);
        this.content.setLength(0);
        this.sysEvent = null;
    }

    private void startAssault(Attributes atts) {
        String byWhom = VillageHandler.attrValue(atts, "byWhom");
        String xname = VillageHandler.attrValue(atts, "xname");
        String time = VillageHandler.attrValue(atts, "time");
        Avatar talkAvatar = this.idAvatarMap.get(byWhom);
        int hour = XmlDecoder.decodeHour(time);
        int minute = XmlDecoder.decodeMinute(time);
        this.talk = new Talk(this.period, TalkType.WOLFONLY, talkAvatar, 0, xname, hour, minute, "");
    }

    private void endAssault() {
        String dialog = this.content.toString();
        this.content.setLength(0);
        this.talk.setDialog(dialog);
    }

    private void startOnStage(Attributes atts) {
        String entryNo = VillageHandler.attrValue(atts, "entryNo");
        String avatarId = VillageHandler.attrValue(atts, "avatarId");
        Avatar avatar = this.idAvatarMap.get(avatarId);
        int entry = Integer.parseInt(entryNo);
        Player player = new Player();
        player.setAvatar(avatar);
        player.setEntryNo(entry);
        this.sysEvent.addPlayerList(Collections.singletonList(player));
    }

    private void startPlayerInfo(Attributes atts) throws SAXException {
        String playerId = VillageHandler.attrValue(atts, "playerId");
        String avatarId = VillageHandler.attrValue(atts, "avatarId");
        String survive = VillageHandler.attrValue(atts, "survive");
        String role = VillageHandler.attrValue(atts, "role");
        String uri = VillageHandler.attrValue(atts, "uri");
        Avatar avatar = this.idAvatarMap.get(avatarId);
        GameRole gameRole = XmlDecoder.decodeRole(role);
        if (uri == null) {
            uri = "";
        }
        Player player = new Player();
        player.setAvatar(avatar);
        player.setRole(gameRole);
        player.setIdName(playerId);
        player.setUrlText(uri);
        if ("true".equals(survive) || "1".equals(survive)) {
            player.setObitDay(-1);
            player.setDestiny(Destiny.ALIVE);
        }
        this.playerList.add(player);
    }

    private void startNominated(Attributes atts) {
        String avatarId = VillageHandler.attrValue(atts, "avatarId");
        String countTxt = VillageHandler.attrValue(atts, "count");
        Avatar avatar = this.idAvatarMap.get(avatarId);
        int count = Integer.parseInt(countTxt);
        Nominated nominated = new Nominated(avatar, count);
        this.nominatedList.add(nominated);
    }

    private void startVote(Attributes atts) {
        String byWhomId = VillageHandler.attrValue(atts, "byWhom");
        String targetId = VillageHandler.attrValue(atts, "target");
        Avatar byWhom = this.idAvatarMap.get(byWhomId);
        Avatar target = this.idAvatarMap.get(targetId);
        InterPlay interPlay = new InterPlay(byWhom, target);
        this.interPlayList.add(interPlay);
    }

    private void startAvatarRef(Attributes atts) {
        String avatarId = VillageHandler.attrValue(atts, "avatarId");
        Avatar avatar = this.idAvatarMap.get(avatarId);
        this.avatarList.add(avatar);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.resetBefore();
    }

    @Override
    public void endDocument() throws SAXException {
        this.resetAfter();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (NS_JINARCHIVE.equals(uri)) {
            this.nsPfx = prefix;
            this.qNameMap = ElemTag.getQNameMap(this.nsPfx);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ElemTag tag = this.decodeElemTag(uri, localName, qName);
        if (tag == null) {
            return;
        }
        if (tag.isSysEventTag()) {
            this.startSysEvent(tag, atts);
            return;
        }
        switch (tag) {
            case VILLAGE: {
                this.startVillage(atts);
                break;
            }
            case AVATAR: {
                this.startAvatar(atts);
                break;
            }
            case PERIOD: {
                this.startPeriod(atts);
                break;
            }
            case TALK: {
                this.startTalk(atts);
                break;
            }
            case LI: {
                this.startLi(atts);
                break;
            }
            case PLAYERINFO: {
                this.startPlayerInfo(atts);
                break;
            }
            case NOMINATED: {
                this.startNominated(atts);
                break;
            }
            case VOTE: {
                this.startVote(atts);
                break;
            }
            case AVATARREF: {
                this.startAvatarRef(atts);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElemTag tag = this.decodeElemTag(uri, localName, qName);
        if (tag == null) {
            return;
        }
        if (tag.isSysEventTag()) {
            this.endSysEvent();
            return;
        }
        switch (tag) {
            case PERIOD: {
                this.endPeriod();
                break;
            }
            case TALK: {
                this.endTalk();
                break;
            }
            case LI: {
                this.endLi();
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inLine) {
            return;
        }
        this.content.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

