/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.data.xml.BotherHandler;
import jp.sfjp.jindolf.data.xml.NoopEntityResolver;
import jp.sfjp.jindolf.data.xml.VillageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class VillageLoader {
    private static final String F_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String F_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String F_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String F_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String F_NAMESPACE = "http://xml.org/sax/features/namespaces";
    private static final String F_NAMESPACEPFX = "http://xml.org/sax/features/namespace-prefixes";

    private VillageLoader() {
        assert (false);
    }

    public static Village parseVillage(File xmlFile) throws IOException, SAXException {
        boolean isNormal;
        Objects.nonNull(xmlFile);
        boolean bl = isNormal = xmlFile.isFile() && xmlFile.exists() && xmlFile.canRead();
        if (!isNormal) {
            throw new IOException(xmlFile.getPath() + "\u3092\u8aad\u307f\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093");
        }
        Path path = xmlFile.toPath();
        Village result = VillageLoader.parseVillage(path);
        return result;
    }

    public static Village parseVillage(Path path) throws IOException, SAXException {
        Village result;
        boolean isNormal;
        Objects.nonNull(path);
        path = path.normalize();
        boolean bl = isNormal = Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path);
        if (!isNormal) {
            throw new IOException(path.toString() + "\u3092\u8aad\u307f\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093");
        }
        try (InputStream is = VillageLoader.pathToStream(path);){
            result = VillageLoader.parseVillage(is);
        }
        return result;
    }

    private static InputStream pathToStream(Path path) throws IOException {
        InputStream is = Files.newInputStream(path, new OpenOption[0]);
        is = new BufferedInputStream(is, 4096);
        return is;
    }

    public static Village parseVillage(InputStream istream) throws IOException, SAXException {
        InputSource isource = new InputSource(istream);
        Village result = VillageLoader.parseVillage(isource);
        return result;
    }

    public static Village parseVillage(InputSource isource) throws IOException, SAXException {
        XMLReader reader = VillageLoader.buildReader();
        VillageHandler handler = new VillageHandler();
        reader.setContentHandler(handler);
        reader.parse(isource);
        Village result = handler.getVillage();
        return result;
    }

    private static SAXParserFactory buildFactory(Schema schema) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setXIncludeAware(false);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature(F_EXTERNAL_GENERAL_ENTITIES, false);
            factory.setFeature(F_EXTERNAL_PARAMETER_ENTITIES, false);
            factory.setFeature(F_LOAD_EXTERNAL_DTD, false);
            factory.setFeature(F_NAMESPACE, true);
            factory.setFeature(F_NAMESPACEPFX, true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        factory.setSchema(schema);
        return factory;
    }

    private static SAXParser buildParser(Schema schema) {
        SAXParser parser;
        SAXParserFactory factory = VillageLoader.buildFactory(schema);
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        try {
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return parser;
    }

    private static XMLReader buildReader() {
        XMLReader reader;
        SAXParser parser = VillageLoader.buildParser(null);
        try {
            reader = parser.getXMLReader();
        }
        catch (SAXException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        reader.setEntityResolver(NoopEntityResolver.NOOP_RESOLVER);
        reader.setErrorHandler(BotherHandler.HANDLER);
        return reader;
    }
}

