/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data.xml;

import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.TalkType;
import org.xml.sax.SAXException;

public final class XmlDecoder {
    private XmlDecoder() {
        assert (false);
    }

    public static PeriodType decodePeriodType(String type) throws SAXException {
        PeriodType result;
        switch (type) {
            case "prologue": {
                result = PeriodType.PROLOGUE;
                break;
            }
            case "progress": {
                result = PeriodType.PROGRESS;
                break;
            }
            case "epilogue": {
                result = PeriodType.EPILOGUE;
                break;
            }
            default: {
                assert (false);
                throw new SAXException("invalid period type:" + type);
            }
        }
        return result;
    }

    public static TalkType decodeTalkType(String type) throws SAXException {
        TalkType result;
        switch (type) {
            case "public": {
                result = TalkType.PUBLIC;
                break;
            }
            case "wolf": {
                result = TalkType.WOLFONLY;
                break;
            }
            case "private": {
                result = TalkType.PRIVATE;
                break;
            }
            case "grave": {
                result = TalkType.GRAVE;
                break;
            }
            default: {
                assert (false);
                throw new SAXException("invalid talk type: " + type);
            }
        }
        return result;
    }

    public static int decodeHour(String txt) {
        int d1 = txt.charAt(0) - 48;
        int d0 = txt.charAt(1) - 48;
        int result = d1 * 10 + d0;
        return result;
    }

    public static int decodeMinute(String txt) {
        int d1 = txt.charAt(3) - 48;
        int d0 = txt.charAt(4) - 48;
        int result = d1 * 10 + d0;
        return result;
    }

    static GameRole decodeRole(String role) throws SAXException {
        GameRole result;
        switch (role) {
            case "innocent": {
                result = GameRole.INNOCENT;
                break;
            }
            case "wolf": {
                result = GameRole.WOLF;
                break;
            }
            case "seer": {
                result = GameRole.SEER;
                break;
            }
            case "shaman": {
                result = GameRole.SHAMAN;
                break;
            }
            case "madman": {
                result = GameRole.MADMAN;
                break;
            }
            case "hunter": {
                result = GameRole.HUNTER;
                break;
            }
            case "frater": {
                result = GameRole.FRATER;
                break;
            }
            case "hamster": {
                result = GameRole.HAMSTER;
                break;
            }
            default: {
                assert (false);
                throw new SAXException("invalid role: " + role);
            }
        }
        return result;
    }
}

