/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.dxchg;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jp.sfjp.jindolf.dxchg.ClipboardAction;

public class TextPopup
extends JPopupMenu {
    private final Action cutAction = ClipboardAction.cutAction();
    private final Action copyAction = ClipboardAction.copyAction();
    private final Action pasteAction = ClipboardAction.pasteAction();
    private final Action selallAction = ClipboardAction.selectallAction();

    public TextPopup() {
        this.buildMenu();
    }

    private void buildMenu() {
        this.add(this.cutAction);
        this.add(this.copyAction);
        this.add(this.pasteAction);
        this.addSeparator();
        this.add(this.selallAction);
    }

    protected boolean hasSelectedContent(JTextComponent textComp) {
        int selEnd;
        int selStart = textComp.getSelectionStart();
        boolean result = selStart != (selEnd = textComp.getSelectionEnd());
        return result;
    }

    protected boolean hasContent(JTextComponent textComp) {
        Document document = textComp.getDocument();
        int docLength = document.getLength();
        return docLength > 0;
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (!(invoker instanceof JTextComponent)) {
            return;
        }
        JTextComponent textComp = (JTextComponent)invoker;
        boolean textSelected = this.hasSelectedContent(textComp);
        this.cutAction.setEnabled(textSelected);
        this.copyAction.setEnabled(textSelected);
        if (!textComp.isEditable()) {
            this.cutAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
        }
        if (this.hasContent(textComp)) {
            this.selallAction.setEnabled(true);
        } else {
            this.selallAction.setEnabled(false);
        }
        super.show(invoker, x, y);
    }
}

