/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import io.github.olyutorskii.quetexj.HeightKeeper;
import io.github.olyutorskii.quetexj.MaxTracker;
import io.github.olyutorskii.quetexj.MvcFacade;
import io.github.olyutorskii.quetexj.SwingLogHandler;
import java.awt.Container;
import java.awt.Dialog;
import java.util.logging.Handler;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.text.Document;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.log.LogUtils;
import jp.sfjp.jindolf.util.Monodizer;

public final class LogFrame
extends JDialog {
    private static final int HEIGHT_LIMIT = 5000;
    private static final int HEIGHT_NEW = 4000;
    private static final int AROUND_TEXT = 3;
    private static final int AROUND_BUTTON = 5;
    private final MvcFacade facade = new MvcFacade();
    private final JScrollPane scrollPane = LogFrame.buildScrollPane(this.facade);
    private final JButton clearButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JCheckBox trackButton = new JCheckBox();
    private final Handler handler;

    public LogFrame() {
        super((Dialog)null);
        this.setupButtons();
        MaxTracker tracker = this.facade.getMaxTracker();
        HeightKeeper keeper = this.facade.getHeightKeeper();
        tracker.setTrackingMode(true);
        keeper.setConditions(5000, 4000);
        SwingLogHandler logHandler = null;
        if (LogUtils.hasLoggingPermission()) {
            Document document = this.facade.getDocument();
            logHandler = new SwingLogHandler(document);
        }
        this.handler = logHandler;
        this.setResizable(true);
        this.setLocationByPlatform(true);
        this.setModal(false);
        this.design();
    }

    private static JScrollPane buildScrollPane(MvcFacade facadeArg) {
        JScrollPane scrollPane = new JScrollPane();
        JScrollBar vbar = scrollPane.getVerticalScrollBar();
        BoundedRangeModel rangeModel = facadeArg.getVerticalBoundedRangeModel();
        vbar.setModel(rangeModel);
        JTextArea textArea = LogFrame.buildTextArea(facadeArg);
        scrollPane.setViewportView(textArea);
        return scrollPane;
    }

    private static JTextArea buildTextArea(MvcFacade facadeArg) {
        JTextArea textArea = facadeArg.getTextArea();
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        Monodizer.monodize(textArea);
        Border border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        textArea.setBorder(border);
        TextPopup popup = new TextPopup();
        textArea.setComponentPopupMenu(popup);
        return textArea;
    }

    private void setupButtons() {
        Action clearAction = this.facade.getClearAction();
        this.clearButton.setAction(clearAction);
        this.clearButton.setText("\u30af\u30ea\u30a2");
        this.closeButton.addActionListener(event -> {
            if (event.getSource() == this.closeButton) {
                this.setVisible(false);
            }
        });
        this.closeButton.setText("\u9589\u3058\u308b");
        JToggleButton.ToggleButtonModel toggleModel = this.facade.getTrackSwitchButtonModel();
        this.trackButton.setModel(toggleModel);
        this.trackButton.setText("\u672b\u5c3e\u306b\u8ffd\u5f93");
    }

    private void design() {
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(this.clearButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.trackButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.closeButton);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        buttonPanel.setBorder(border);
        Container content = this.getContentPane();
        BoxLayout layout = new BoxLayout(content, 1);
        content.setLayout(layout);
        content.add(this.scrollPane);
        content.add(buttonPanel);
    }

    public Handler getHandler() {
        return this.handler;
    }
}

