/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MomentaryHandler
extends Handler {
    private final List<LogRecord> logList = Collections.synchronizedList(new LinkedList());
    private final List<LogRecord> unmodList = Collections.unmodifiableList(this.logList);

    public static List<MomentaryHandler> getMomentaryHandlers(Logger logger) {
        List<MomentaryHandler> result = Arrays.stream(logger.getHandlers()).filter(handler -> handler instanceof MomentaryHandler).map(handler -> (MomentaryHandler)handler).collect(Collectors.toList());
        return result;
    }

    public static void removeMomentaryHandlers(Logger logger) {
        MomentaryHandler.getMomentaryHandlers(logger).forEach(handler -> logger.removeHandler((Handler)handler));
    }

    public List<LogRecord> getRecordList() {
        return this.unmodList;
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        record.getSourceMethodName();
        this.logList.add(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.setLevel(Level.OFF);
        this.flush();
    }

    public void transfer(Handler handler) throws NullPointerException {
        Objects.nonNull(handler);
        if (handler == this) {
            return;
        }
        this.close();
        this.logList.forEach(record -> handler.publish((LogRecord)record));
        handler.flush();
        this.logList.clear();
    }
}

