/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.net;

import io.bitbucket.olyutorskii.jiocema.DecodeBreakException;
import io.bitbucket.olyutorskii.jiocema.DecodeNotifier;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import jp.osdn.jindolf.parser.content.ContentBuilder;
import jp.osdn.jindolf.parser.content.ContentBuilderSJ;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.osdn.jindolf.parser.content.SjisNotifier;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.net.HtmlSequence;
import jp.sfjp.jindolf.net.HttpUtils;
import jp.sfjp.jindolf.net.TallyInputStream;

public class ServerAccess {
    private static final int BUFLEN_CONTENT = 204800;
    private static final String USER_AGENT = HttpUtils.getUserAgentName();
    private static final String JINRO_CGI = "./index.rb";
    private static final Map<String, SoftReference<BufferedImage>> IMAGE_CACHE;
    private static final Object CACHE_LOCK;
    private static final Logger LOGGER;
    private final URL baseURL;
    private final Charset charset;
    private final boolean isSJIS;
    private final boolean isUTF8;
    private Proxy proxy = Proxy.NO_PROXY;
    private long lastServerMs;
    private long lastLocalMs;
    private long lastSystemMs;

    public ServerAccess(URL baseURL, Charset charset) throws IllegalArgumentException {
        this.baseURL = baseURL;
        this.charset = charset;
        String charsetName = this.charset.name();
        if ("Shift_JIS".equalsIgnoreCase(charsetName)) {
            this.isSJIS = true;
            this.isUTF8 = false;
        } else if ("UTF-8".equalsIgnoreCase(charsetName)) {
            this.isSJIS = false;
            this.isUTF8 = true;
        } else {
            throw new IllegalArgumentException(charsetName);
        }
        assert (this.isSJIS ^ this.isUTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getImageCache(String key) {
        BufferedImage image;
        if (key == null) {
            return null;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            SoftReference<BufferedImage> ref = IMAGE_CACHE.get(key);
            if (ref == null) {
                return null;
            }
            image = ref.get();
            if (image == null) {
                IMAGE_CACHE.remove(key);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putImageCache(String key, BufferedImage image) {
        if (key == null || image == null) {
            return;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (ServerAccess.getImageCache(key) != null) {
                return;
            }
            SoftReference<BufferedImage> ref = new SoftReference<BufferedImage>(image);
            IMAGE_CACHE.put(key, ref);
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    protected URL getQueryURL(String query) {
        URL result;
        if (query.length() >= 1 && query.charAt(0) != '?') {
            return null;
        }
        try {
            result = new URL(this.getBaseURL(), JINRO_CGI + query);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        return result;
    }

    public URL getVillageURL(Village village) {
        String query = village.getCGIQuery();
        URL url = this.getQueryURL(query);
        return url;
    }

    public URL getPeriodURL(Period period) {
        String query = period.getCGIQuery();
        URL url = this.getQueryURL(query);
        return url;
    }

    public DecodedContent downloadHTMLStream(InputStream istream) throws IOException {
        ContentBuilder builder;
        DecodeNotifier decoder;
        if (this.isSJIS) {
            decoder = new SjisNotifier();
            builder = new ContentBuilderSJ(204800);
        } else if (this.isUTF8) {
            decoder = new DecodeNotifier(this.charset.newDecoder());
            builder = new ContentBuilder(204800);
        } else {
            assert (false);
            return null;
        }
        decoder.setCharDecodeListener(builder);
        try {
            decoder.decode(istream);
        }
        catch (DecodeBreakException e) {
            return null;
        }
        return builder.getContent();
    }

    protected HtmlSequence downloadHTML(URL url) throws IOException {
        DecodedContent html;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        connection.connect();
        long datems = this.updateLastAccess(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String logMessage = "\u767a\u8a00\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            logMessage = logMessage + HttpUtils.formatHttpStat(connection, 0L, 0L);
            LOGGER.warning(logMessage);
            return null;
        }
        String cs = HttpUtils.getHTMLCharset(connection);
        if (!cs.equalsIgnoreCase(this.charset.name())) {
            return null;
        }
        try (InputStream is = TallyInputStream.getInputStream(connection);){
            html = this.downloadHTMLStream(is);
        }
        connection.disconnect();
        HtmlSequence hseq = new HtmlSequence(url, datems, html);
        return hseq;
    }

    protected HtmlSequence downloadHTML(String query) throws IOException {
        URL url = this.getQueryURL(query);
        HtmlSequence result = this.downloadHTML(url);
        return result;
    }

    public HtmlSequence getHTMLTopPage() throws IOException {
        return this.downloadHTML("");
    }

    public HtmlSequence getHTMLLandList() throws IOException {
        return this.downloadHTML("?cmd=log");
    }

    public HtmlSequence getHTMLBoneHead(Village village) throws IOException {
        String query = village.getCGIQuery();
        return this.downloadHTML(query + "&meslog=");
    }

    public HtmlSequence getHTMLVillage(Village village) throws IOException {
        URL url = this.getVillageURL(village);
        return this.downloadHTML(url);
    }

    public HtmlSequence getHTMLPeriod(Period period) throws IOException {
        URL url = this.getPeriodURL(period);
        return this.downloadHTML(url);
    }

    public BufferedImage downloadImage(String url) throws IOException {
        URL absolute;
        try {
            URL base = this.getBaseURL();
            absolute = new URL(base, url);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        String urlTxt = absolute.toString();
        BufferedImage image = ServerAccess.getImageCache(urlTxt);
        if (image != null) {
            return image;
        }
        HttpURLConnection connection = (HttpURLConnection)absolute.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(true);
        connection.setInstanceFollowRedirects(true);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String logMessage = "\u30a4\u30e1\u30fc\u30b8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            logMessage = logMessage + HttpUtils.formatHttpStat(connection, 0L, 0L);
            LOGGER.warning(logMessage);
            return null;
        }
        try (InputStream is = TallyInputStream.getInputStream(connection);){
            image = ImageIO.read(is);
        }
        connection.disconnect();
        ServerAccess.putImageCache(urlTxt, image);
        return image;
    }

    public long updateLastAccess(HttpURLConnection connection) {
        this.lastServerMs = connection.getDate();
        this.lastLocalMs = System.currentTimeMillis();
        this.lastSystemMs = System.nanoTime() / 1000000L;
        return this.lastServerMs;
    }

    static {
        CACHE_LOCK = new Object();
        LOGGER = Logger.getAnonymousLogger();
        IMAGE_CACHE = new HashMap<String, SoftReference<BufferedImage>>();
    }
}

