/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sourceforge.jindolf.corelib.LandDef;

public class AvatarPics {
    private final Land land;
    private final Map<Avatar, BufferedImage> faceImageMap;
    private final Map<Avatar, BufferedImage> bodyImageMap;
    private final Map<Avatar, BufferedImage> faceMonoImageMap;
    private final Map<Avatar, BufferedImage> bodyMonoImageMap;
    private BufferedImage graveImage;
    private BufferedImage graveBodyImage;

    public AvatarPics(Land land) {
        Objects.nonNull(land);
        this.land = land;
        this.faceImageMap = new HashMap<Avatar, BufferedImage>();
        this.bodyImageMap = new HashMap<Avatar, BufferedImage>();
        this.faceMonoImageMap = new HashMap<Avatar, BufferedImage>();
        this.bodyMonoImageMap = new HashMap<Avatar, BufferedImage>();
        this.graveImage = null;
        this.graveBodyImage = null;
    }

    public BufferedImage getAvatarFaceImage(Avatar avatar) {
        BufferedImage result = this.faceImageMap.get(avatar);
        if (result != null) {
            return result;
        }
        LandDef landDef = this.land.getLandDef();
        String template = landDef.getFaceURITemplate();
        int serialNo = avatar.getIdNum();
        result = this.loadAvatarImage(template, serialNo);
        this.faceImageMap.put(avatar, result);
        return result;
    }

    public void setAvatarFaceImage(Avatar avatar, BufferedImage image) {
        this.faceImageMap.remove(avatar);
        this.faceMonoImageMap.remove(avatar);
        this.faceImageMap.put(avatar, image);
    }

    public BufferedImage getAvatarBodyImage(Avatar avatar) {
        BufferedImage result = this.bodyImageMap.get(avatar);
        if (result != null) {
            return result;
        }
        LandDef landDef = this.land.getLandDef();
        String template = landDef.getBodyURITemplate();
        int serialNo = avatar.getIdNum();
        result = this.loadAvatarImage(template, serialNo);
        this.bodyImageMap.put(avatar, result);
        return result;
    }

    public void setAvatarBodyImage(Avatar avatar, BufferedImage image) {
        this.bodyImageMap.remove(avatar);
        this.bodyMonoImageMap.remove(avatar);
        this.bodyImageMap.put(avatar, image);
    }

    private BufferedImage loadAvatarImage(String template, int serialNo) {
        String uri = MessageFormat.format(template, serialNo);
        BufferedImage result = this.land.downloadImage(uri);
        if (result == null) {
            result = GUIUtils.getNoImage();
        }
        return result;
    }

    public BufferedImage getAvatarFaceMonoImage(Avatar avatar) {
        BufferedImage result = this.faceMonoImageMap.get(avatar);
        if (result == null) {
            result = this.getAvatarFaceImage(avatar);
            result = GUIUtils.createMonoImage(result);
            this.faceMonoImageMap.put(avatar, result);
        }
        return result;
    }

    public BufferedImage getAvatarBodyMonoImage(Avatar avatar) {
        BufferedImage result = this.bodyMonoImageMap.get(avatar);
        if (result == null) {
            result = this.getAvatarBodyImage(avatar);
            result = GUIUtils.createMonoImage(result);
            this.bodyMonoImageMap.put(avatar, result);
        }
        return result;
    }

    public BufferedImage getGraveImage() {
        BufferedImage result;
        if (this.graveImage != null) {
            return this.graveImage;
        }
        this.graveImage = result = this.land.getGraveIconImage();
        return result;
    }

    public void setGraveImage(BufferedImage image) {
        this.graveImage = image;
    }

    public BufferedImage getGraveBodyImage() {
        BufferedImage result;
        if (this.graveBodyImage != null) {
            return this.graveBodyImage;
        }
        this.graveBodyImage = result = this.land.getGraveBodyImage();
        return result;
    }

    public void setGraveBodyImage(BufferedImage image) {
        this.graveBodyImage = image;
    }

    public void preload() {
        for (Avatar avatar : Avatar.getPredefinedAvatarList()) {
            this.getAvatarFaceImage(avatar);
            this.getAvatarBodyImage(avatar);
            this.getAvatarFaceMonoImage(avatar);
            this.getAvatarBodyMonoImage(avatar);
            this.getGraveImage();
            this.getGraveBodyImage();
        }
    }
}

