/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.LandsTreeModel;
import jp.sfjp.jindolf.view.VillageIconRenderer;

public class LandsTree
extends JPanel {
    private static final String TIP_ASCEND = "\u62bc\u3059\u3068\u964d\u9806\u306b";
    private static final String TIP_DESCEND = "\u62bc\u3059\u3068\u6607\u9806\u306b";
    private static final String TIP_ORDER = "\u9078\u629e\u4e2d\u306e\u56fd\u306e\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u76f4\u3059";
    private static final String RES_DIR = "resources/image/";
    private static final String RES_ASCEND = "resources/image/tb_ascend.png";
    private static final String RES_DESCEND = "resources/image/tb_descend.png";
    private static final String RES_RELOAD = "resources/image/tb_reload.png";
    private static final Icon ICON_ASCEND = ResourceManager.getButtonIcon("resources/image/tb_ascend.png");
    private static final Icon ICON_DESCEND = ResourceManager.getButtonIcon("resources/image/tb_descend.png");
    private static final Icon ICON_RELOAD = ResourceManager.getButtonIcon("resources/image/tb_reload.png");
    private final JButton orderButton = new JButton();
    private final JButton reloadButton = new JButton();
    private final JTree treeView = new JTree();
    private boolean ascending = false;

    public LandsTree() {
        TreeSelectionModel selModel = this.treeView.getSelectionModel();
        selModel.setSelectionMode(1);
        this.setupObserver();
        this.decorateButtons();
        this.design();
    }

    private void setupObserver() {
        this.orderButton.addActionListener(ev -> this.toggleTreeOrder());
        this.treeView.addTreeSelectionListener(ev -> this.updateReloadButton(ev));
        this.reloadButton.setActionCommand("VILLAGELIST");
    }

    private void decorateButtons() {
        this.orderButton.setIcon(ICON_DESCEND);
        this.orderButton.setToolTipText(TIP_DESCEND);
        this.orderButton.setMargin(new Insets(1, 1, 1, 1));
        this.reloadButton.setIcon(ICON_RELOAD);
        this.reloadButton.setToolTipText(TIP_ORDER);
        this.reloadButton.setMargin(new Insets(1, 1, 1, 1));
    }

    private void design() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.orderButton);
        toolBar.add(this.reloadButton);
        JComponent landSelector = this.createLandSelector();
        this.add((Component)toolBar, "North");
        this.add((Component)landSelector, "Center");
    }

    private JComponent createLandSelector() {
        this.treeView.setRootVisible(false);
        this.treeView.setCellRenderer(new VillageIconRenderer());
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.treeView.setBorder(border);
        JScrollPane landSelector = new JScrollPane(this.treeView);
        return landSelector;
    }

    public JButton getReloadVillageListButton() {
        return this.reloadButton;
    }

    public JTree getTreeView() {
        return this.treeView;
    }

    public void expandLand(Land land) {
        TreeModel model = this.treeView.getModel();
        Object root = model.getRoot();
        Object[] path = new Object[]{root, land};
        TreePath treePath = new TreePath(path);
        this.treeView.expandPath(treePath);
    }

    private LandsTreeModel getLandsModel() {
        TreeModel model = this.treeView.getModel();
        if (model instanceof LandsTreeModel) {
            return (LandsTreeModel)model;
        }
        return null;
    }

    private boolean toggleTreeOrder() {
        Icon newIcon;
        String newTip;
        boolean bl = this.ascending = !this.ascending;
        if (this.ascending) {
            newTip = TIP_ASCEND;
            newIcon = ICON_ASCEND;
        } else {
            newTip = TIP_DESCEND;
            newIcon = ICON_DESCEND;
        }
        this.orderButton.setToolTipText(newTip);
        this.orderButton.setIcon(newIcon);
        TreePath lastPath = this.treeView.getSelectionPath();
        LandsTreeModel model = this.getLandsModel();
        if (model != null) {
            model.setAscending(this.ascending);
        }
        if (lastPath != null) {
            this.treeView.setSelectionPath(lastPath);
            this.treeView.scrollPathToVisible(lastPath);
        }
        return this.ascending;
    }

    private void updateReloadButton(TreeSelectionEvent event) {
        Object selObj;
        boolean reloadEnable = false;
        TreePath path = event.getNewLeadSelectionPath();
        if (path != null && (selObj = path.getLastPathComponent()) instanceof Land) {
            reloadEnable = true;
        }
        this.reloadButton.setEnabled(reloadEnable);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.treeView != null) {
            this.treeView.setCellRenderer(new VillageIconRenderer());
        }
    }
}

