/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.data.Avatar;

public final class LocalAvatarImg {
    private static final String IMGDIR = "resources/image/avatar";
    private static final String TEMPLATE_FACE = "resources/image/avatar/face{0,number,#00}.png";
    private static final String TEMPLATE_BODY = "resources/image/avatar/body{0,number,#00}.png";
    private static final String RES_GRAVE = "resources/image/avatar/face99.png";
    private static final String RES_GRAVEBODY = "resources/image/avatar/body99.png";
    private static final Map<String, BufferedImage> FACE_MAP = LocalAvatarImg.loadTemplateResImg("resources/image/avatar/face{0,number,#00}.png");
    private static final Map<String, BufferedImage> BODY_MAP = LocalAvatarImg.loadTemplateResImg("resources/image/avatar/body{0,number,#00}.png");
    private static final BufferedImage GRAVE_IMAGE = ResourceManager.getBufferedImage("resources/image/avatar/face99.png");
    private static final BufferedImage GRAVEBODY_IMAGE = ResourceManager.getBufferedImage("resources/image/avatar/body99.png");

    private LocalAvatarImg() {
        assert (false);
    }

    private static Map<String, BufferedImage> loadTemplateResImg(String resForm) {
        HashMap result = new HashMap();
        Avatar.getPredefinedAvatarList().forEach(avatar -> {
            String avatarId = avatar.getIdentifier();
            int idNum = avatar.getIdNum();
            String res = MessageFormat.format(resForm, idNum);
            BufferedImage img = ResourceManager.getBufferedImage(res);
            assert (img != null);
            result.put(avatarId, img);
        });
        return Collections.unmodifiableMap(result);
    }

    public static BufferedImage getAvatarFaceImage(String avatarId) {
        BufferedImage result = FACE_MAP.get(avatarId);
        return result;
    }

    public static BufferedImage getAvatarBodyImage(String avatarId) {
        BufferedImage result = BODY_MAP.get(avatarId);
        return result;
    }

    public static BufferedImage getGraveImage() {
        return GRAVE_IMAGE;
    }

    public static BufferedImage getGraveBodyImage() {
        return GRAVEBODY_IMAGE;
    }
}

