/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.nio.file.Path;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import jp.sfjp.jindolf.config.FileUtils;

public final class LockErrorPane
extends JOptionPane {
    private static final String FORM_MAIN = "<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb<br/><center>[&nbsp;{0}&nbsp;]</center><br/>\u306e\u30ed\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br/>\u8003\u3048\u3089\u308c\u308b\u539f\u56e0\u3068\u3057\u3066\u306f\u3001<br/><ul><li>\u524d\u56de\u8d77\u52d5\u3057\u305fJindolf\u306e\u7d42\u4e86\u304c\u6b63\u3057\u304f\u884c\u308f\u308c\u306a\u304b\u3063\u305f<li>\u4eca\u3069\u3053\u304b\u3067\u4ed6\u306eJindolf\u304c\u52d5\u3044\u3066\u3044\u308b</ul>\u306a\u3069\u304c\u8003\u3048\u3089\u308c\u307e\u3059\u3002<br/><hr/></html>";
    private static final String LABEL_CONTINUE = "\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f7f\u308f\u305a\u306b\u8d77\u52d5\u3092\u7d9a\u884c";
    private static final String LABEL_RETRY = "\u518d\u5ea6\u30ed\u30c3\u30af\u53d6\u5f97\u3092\u8a66\u3059";
    private static final String LABEL_FORCE = "<html>\u30ed\u30c3\u30af\u3092\u5f37\u5236\u89e3\u9664<br/> (\u203b\u4ed6\u306eJindolf\u3068\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u304c\u885d\u7a81\u3059\u308b\u304b\u3082\u2026)</html>";
    private static final String LABEL_OK = "OK";
    private static final String LABEL_ABORT = "\u8d77\u52d5\u4e2d\u6b62";
    private static final String[] OPTIONS = new String[]{"OK", "\u8d77\u52d5\u4e2d\u6b62"};
    private final JRadioButton continueButton = new JRadioButton("\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f7f\u308f\u305a\u306b\u8d77\u52d5\u3092\u7d9a\u884c");
    private final JRadioButton retryButton = new JRadioButton("\u518d\u5ea6\u30ed\u30c3\u30af\u53d6\u5f97\u3092\u8a66\u3059");
    private final JRadioButton forceButton = new JRadioButton("<html>\u30ed\u30c3\u30af\u3092\u5f37\u5236\u89e3\u9664<br/> (\u203b\u4ed6\u306eJindolf\u3068\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u304c\u885d\u7a81\u3059\u308b\u304b\u3082\u2026)</html>");

    public LockErrorPane(Path lockFile) {
        ButtonGroup bgrp = new ButtonGroup();
        bgrp.add(this.continueButton);
        bgrp.add(this.retryButton);
        bgrp.add(this.forceButton);
        this.continueButton.setSelected(true);
        String lockName = FileUtils.getHtmledFileName(lockFile);
        String htmlMessage = MessageFormat.format(FORM_MAIN, lockName);
        Object[] msg = new Object[]{htmlMessage, this.continueButton, this.retryButton, this.forceButton};
        this.setMessage(msg);
        this.setOptions(OPTIONS);
        this.setMessageType(0);
    }

    public static boolean isAborted(Object value) {
        boolean flag = LABEL_ABORT.equals(value);
        return flag;
    }

    public boolean isRadioContinue() {
        return this.continueButton.isSelected();
    }

    public boolean isRadioRetry() {
        return this.retryButton.isSelected();
    }

    public boolean isRadioForce() {
        return this.forceButton.isSelected();
    }
}

