/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.glyph.AnchorHitListener;
import jp.sfjp.jindolf.glyph.Discussion;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.view.PeriodView;
import jp.sfjp.jindolf.view.VillageInfoPanel;

public final class TabBrowser
extends JTabbedPane {
    private static final int PERIODTAB_OFFSET = 1;
    private Village village;
    private final VillageInfoPanel villageInfo = new VillageInfoPanel();
    private FontInfo fontInfo;
    private DialogPref dialogPref;

    public TabBrowser() {
        this.setTabPlacement(1);
        this.setTabLayoutPolicy(0);
        JComponent infoPane = this.decorateVillageInfo();
        this.addTab("\u6751\u60c5\u5831", infoPane);
        this.initTab();
    }

    private JComponent decorateVillageInfo() {
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.villageInfo.setBorder(border);
        JScrollPane result = new JScrollPane(this.villageInfo);
        return result;
    }

    private void initTab() {
        this.modifyTabCount(0);
        this.updateVillageInfo();
        this.showVillageInfoTab();
        this.repaint();
        this.revalidate();
    }

    private void modifyTabCount(int periods) {
        int periodTabs;
        while (periods > (periodTabs = this.getTabCount() - 1)) {
            String tabTitle = "";
            JPanel dummy = new JPanel();
            this.addTab(tabTitle, dummy);
        }
        while (periods < (periodTabs = this.getTabCount() - 1)) {
            int lastTabIndex = this.getTabCount() - 1;
            this.remove(lastTabIndex);
        }
    }

    private void fillPeriodTab() {
        this.village.getPeriodList().stream().forEachOrdered(period -> {
            PeriodView periodView = this.buildPeriodView((Period)period);
            String caption = period.getCaption();
            int tabIndex = period.getDay() + 1;
            this.setComponentAt(tabIndex, periodView);
            this.setTitleAt(tabIndex, caption);
        });
    }

    public Village getVillage() {
        return this.village;
    }

    public final void setVillage(Village village) {
        Village oldVillage = this.village;
        if (oldVillage != null && village != oldVillage) {
            oldVillage.unloadPeriods();
        }
        this.village = village;
        if (this.village == null) {
            this.initTab();
            return;
        }
        if (this.village != oldVillage) {
            this.showVillageInfoTab();
        }
        this.updateVillageInfo();
        int periodNum = this.village.getPeriodSize();
        this.modifyTabCount(periodNum);
        this.fillPeriodTab();
        this.repaint();
        this.revalidate();
    }

    private void updateVillageInfo() {
        Village target = this.getVillage();
        this.villageInfo.updateVillage(target);
    }

    private PeriodView buildPeriodView(Period period) {
        Objects.nonNull(period);
        PeriodView result = new PeriodView(period);
        result.setFontInfo(this.fontInfo);
        result.setDialogPref(this.dialogPref);
        Discussion discussion = result.getDiscussion();
        for (ActionListener actionListener : this.getActionListeners()) {
            discussion.addActionListener(actionListener);
        }
        for (EventListener eventListener : this.getAnchorHitListeners()) {
            discussion.addAnchorHitListener((AnchorHitListener)eventListener);
        }
        return result;
    }

    public List<PeriodView> getPeriodViewList() {
        int tabCount = this.getTabCount();
        int periodCount = tabCount - 1;
        ArrayList<PeriodView> result = new ArrayList<PeriodView>(periodCount);
        for (int tabIndex = 1; tabIndex < tabCount; ++tabIndex) {
            Component component = this.getComponent(tabIndex);
            PeriodView periodView = (PeriodView)component;
            result.add(periodView);
        }
        return result;
    }

    public PeriodView getPeriodView(int periodIndex) {
        int tabIndex = periodIndex + 1;
        if (tabIndex < 1 || this.getTabCount() <= tabIndex) {
            return null;
        }
        Component component = this.getComponentAt(tabIndex);
        if (!(component instanceof PeriodView)) {
            return null;
        }
        PeriodView periodView = (PeriodView)component;
        return periodView;
    }

    public PeriodView currentPeriodView() {
        int tabIndex = this.getSelectedIndex();
        int periodIndex = tabIndex - 1;
        PeriodView result = this.getPeriodView(periodIndex);
        return result;
    }

    public void setFontInfo(FontInfo fontInfo) {
        Objects.nonNull(fontInfo);
        this.fontInfo = fontInfo;
        this.getPeriodViewList().forEach(periodView -> periodView.setFontInfo(this.fontInfo));
    }

    public void setDialogPref(DialogPref dialogPref) {
        Objects.nonNull(dialogPref);
        this.dialogPref = dialogPref;
        this.getPeriodViewList().forEach(periodView -> periodView.setDialogPref(this.dialogPref));
    }

    private void showVillageInfoTab() {
        this.setSelectedIndex(0);
    }

    public void showPeriodTab(int periodIndex) {
        int tabIndex = periodIndex + 1;
        this.setSelectedIndex(tabIndex);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
        this.getPeriodViewList().stream().map(PeriodView::getDiscussion).forEach(discussion -> discussion.addActionListener(listener));
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
        this.getPeriodViewList().stream().map(PeriodView::getDiscussion).forEach(discussion -> discussion.removeActionListener(listener));
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public void addAnchorHitListener(AnchorHitListener listener) {
        this.listenerList.add(AnchorHitListener.class, listener);
        this.getPeriodViewList().stream().map(PeriodView::getDiscussion).forEach(discussion -> discussion.addAnchorHitListener(listener));
    }

    public void removeAnchorHitListener(AnchorHitListener listener) {
        this.listenerList.remove(AnchorHitListener.class, listener);
        this.getPeriodViewList().stream().map(PeriodView::getDiscussion).forEach(discussion -> discussion.removeAnchorHitListener(listener));
    }

    public AnchorHitListener[] getAnchorHitListeners() {
        return (AnchorHitListener[])this.getListeners(AnchorHitListener.class);
    }
}

