/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.view.LandInfoPanel;
import jp.sfjp.jindolf.view.LandsTree;
import jp.sfjp.jindolf.view.TabBrowser;

public final class TopView
extends JPanel {
    private static final String INITCARD = "INITCARD";
    private static final String LANDCARD = "LANDINFO";
    private static final String BROWSECARD = "BROWSER";
    private static final String MSG_THANKS = VerInfo.TITLE + " " + VerInfo.VERSION + " \u3092\u4f7f\u3063\u3066\u304f\u308c\u3066\u3042\u308a\u304c\u3068\u3046\uff01";
    private final JComponent cards;
    private final CardLayout cardLayout = new CardLayout();
    private final LandsTree landsTreeView = new LandsTree();
    private final LandInfoPanel landInfo = new LandInfoPanel();
    private final JTextField sysMessage = new JTextField("");
    private final JProgressBar progressBar = new JProgressBar();
    private final TabBrowser tabBrowser = new TabBrowser();
    private final JComponent browsePanel = this.createBrowsePanel();

    public TopView() {
        this.cards = this.createCards();
        JComponent split = this.createSplitPane(this.landsTreeView, this.cards);
        JComponent statusBar = this.createStatusBar();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)split, "Center");
        this.add((Component)statusBar, "South");
    }

    private JComponent createCards() {
        JComponent initCard = this.createInitCard();
        JComponent landInfoCard = this.createLandInfoCard();
        JPanel cardContainer = new JPanel();
        cardContainer.setLayout(this.cardLayout);
        cardContainer.add(INITCARD, initCard);
        cardContainer.add(LANDCARD, landInfoCard);
        cardContainer.add(BROWSECARD, this.browsePanel);
        return cardContainer;
    }

    private JComponent createInitCard() {
        StringBuilder init = new StringBuilder();
        init.append("\u2190    \u4eba\u72fcBBS\u30b5\u30fc\u30d0\u304b\u3089\u6751\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044");
        init.append("<br/><br/>\u307e\u305f\u306f\u300c\u30d5\u30a1\u30a4\u30eb\u300d\u30e1\u30cb\u30e5\u30fc\u304b\u3089");
        init.append("<br/>JinArchive\u5f62\u5f0f\u3067\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u305f");
        init.append("<br/>\u30a2\u30fc\u30ab\u30a4\u30d6XML\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3044\u3066\u304f\u3060\u3055\u3044");
        init.insert(0, "<font 'size=+1'>").append("</font>");
        init.insert(0, "<center>").append("</center>");
        init.insert(0, "<body>").append("</body>");
        init.insert(0, "<html>").append("</html>");
        JLabel initMessage = new JLabel(init.toString());
        StringBuilder warn = new StringBuilder();
        warn.append("\u203b \u305f\u307e\u306b\u306fWeb\u30d6\u30e9\u30a6\u30b6\u3067\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3001");
        warn.append("<br/>");
        warn.append("\u904b\u55b6\u306e\u52d5\u5411\u3092\u78ba\u304b\u3081\u3088\u3046\u306d\uff01");
        warn.insert(0, "<font 'size=+1'>").append("</font>");
        warn.insert(0, "<center>").append("</center>");
        warn.insert(0, "<body>").append("</body>");
        warn.insert(0, "<html>").append("</html>");
        JLabel warnMessage = new JLabel(warn.toString());
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 10;
        constraints.gridx = 0;
        panel.add((Component)initMessage, constraints);
        panel.add((Component)warnMessage, constraints);
        JScrollPane scrollPane = new JScrollPane(panel);
        return scrollPane;
    }

    private JComponent createLandInfoCard() {
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.landInfo.setBorder(border);
        JScrollPane scrollPane = new JScrollPane(this.landInfo);
        return scrollPane;
    }

    private JComponent createBrowsePanel() {
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        panel.setLayout(layout);
        panel.add((Component)this.tabBrowser, "Center");
        return panel;
    }

    public void setBrowseToolBar(JToolBar toolbar) {
        this.browsePanel.add((Component)toolbar, "North");
    }

    private JComponent createSplitPane(JComponent left, JComponent right) {
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(left);
        split.setRightComponent(right);
        split.setOrientation(1);
        split.setContinuousLayout(false);
        split.setOneTouchExpandable(true);
        split.setDividerLocation(200);
        return split;
    }

    private JComponent createStatusBar() {
        this.sysMessage.setText(MSG_THANKS);
        this.sysMessage.setEditable(false);
        Border inside = BorderFactory.createBevelBorder(1);
        Border outside = BorderFactory.createEmptyBorder(2, 5, 2, 2);
        CompoundBorder border = new CompoundBorder(inside, outside);
        this.sysMessage.setBorder(border);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setOrientation(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(99);
        this.progressBar.setValue(0);
        JPanel statusBar = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        statusBar.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        statusBar.add((Component)this.sysMessage, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        statusBar.add((Component)this.progressBar, constraints);
        return statusBar;
    }

    public JTree getTreeView() {
        return this.landsTreeView.getTreeView();
    }

    public TabBrowser getTabBrowser() {
        return this.tabBrowser;
    }

    public LandsTree getLandsTree() {
        return this.landsTreeView;
    }

    public void setBusy(boolean busy) {
        this.progressBar.setIndeterminate(busy);
    }

    public void updateSysMessage(String message) {
        String text = message;
        if (message == null) {
            text = "";
        }
        this.sysMessage.setText(text);
    }

    public String getSysMessage() {
        String result = this.sysMessage.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void showInitPanel() {
        this.cardLayout.show(this.cards, INITCARD);
    }

    public void showVillageInfo(Village village) {
        this.tabBrowser.setVillage(village);
        this.cardLayout.show(this.cards, BROWSECARD);
    }

    public void showLandInfo(Land land) {
        this.landInfo.update(land);
        this.cardLayout.show(this.cards, LANDCARD);
    }
}

