/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.data.Village;

public class VillageIconRenderer
extends DefaultTreeCellRenderer {
    private static final Icon ICON_PROLOGUE = ResourceManager.getSquareIcon("resources/image/vs_prologue.png", 16);
    private static final Icon ICON_PROGRESS = ResourceManager.getSquareIcon("resources/image/vs_progress.png", 16);
    private static final Icon ICON_EPILOGUE = ResourceManager.getSquareIcon("resources/image/vs_epilogue.png", 16);
    private static final Icon ICON_GAMEOVER = ResourceManager.getSquareIcon("resources/image/vs_gameover.png", 16);
    private static final Icon ICON_INVALID = ResourceManager.getSquareIcon("resources/image/vs_cross.png", 16);
    private static final int MARK_SZ = 16;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (leaf && value instanceof Village) {
            Village village = (Village)value;
            Icon icon = null;
            switch (village.getState()) {
                case PROLOGUE: {
                    icon = ICON_PROLOGUE;
                    break;
                }
                case PROGRESS: {
                    icon = ICON_PROGRESS;
                    break;
                }
                case EPILOGUE: {
                    icon = ICON_EPILOGUE;
                    break;
                }
                case GAMEOVER: {
                    icon = ICON_GAMEOVER;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (!village.isValid()) {
                icon = ICON_INVALID;
            }
            this.setLeafIcon(icon);
        }
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        return comp;
    }
}

