/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.EventQueue;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.log.LogFrame;
import jp.sfjp.jindolf.summary.DaySummary;
import jp.sfjp.jindolf.summary.VillageDigest;
import jp.sfjp.jindolf.view.FilterPanel;
import jp.sfjp.jindolf.view.FindPanel;
import jp.sfjp.jindolf.view.HelpFrame;
import jp.sfjp.jindolf.view.OptionPanel;
import jp.sfjp.jindolf.view.TopFrame;

public class WindowManager {
    private static final String TITLE_FILTER = WindowManager.getFrameTitle("\u767a\u8a00\u30d5\u30a3\u30eb\u30bf");
    private static final String TITLE_LOGGER = WindowManager.getFrameTitle("\u30ed\u30b0\u8868\u793a");
    private static final String TITLE_OPTION = WindowManager.getFrameTitle("\u30aa\u30d7\u30b7\u30e7\u30f3\u8a2d\u5b9a");
    private static final String TITLE_FIND = WindowManager.getFrameTitle("\u767a\u8a00\u691c\u7d22");
    private static final String TITLE_DIGEST = WindowManager.getFrameTitle("\u6751\u306e\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8");
    private static final String TITLE_DAYSUMMARY = WindowManager.getFrameTitle("\u767a\u8a00\u96c6\u8a08");
    private static final String TITLE_HELP = WindowManager.getFrameTitle("\u30d8\u30eb\u30d7");
    private final TopFrame topFrame = new TopFrame();
    private FilterPanel filterPanel;
    private LogFrame logFrame;
    private OptionPanel optionPanel;
    private FindPanel findPanel;
    private VillageDigest villageDigest;
    private DaySummary daySummary;
    private HelpFrame helpFrame;
    private final List<Window> windowSet;

    public WindowManager() {
        this.topFrame.setVisible(false);
        JOptionPane.setRootFrame(this.topFrame);
        this.windowSet = new LinkedList<Window>();
        this.windowSet.add(this.topFrame);
    }

    private static String getFrameTitle(String text) {
        String result = VerInfo.getFrameTitle(text);
        return result;
    }

    protected FilterPanel createFilterPanel() {
        FilterPanel result = new FilterPanel();
        result.setTitle(TITLE_FILTER);
        result.pack();
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public FilterPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = this.createFilterPanel();
        }
        return this.filterPanel;
    }

    protected LogFrame createLogFrame() {
        LogFrame result = new LogFrame();
        result.setTitle(TITLE_LOGGER);
        result.pack();
        result.setSize(600, 500);
        result.setLocationByPlatform(true);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public LogFrame getLogFrame() {
        if (this.logFrame == null) {
            this.logFrame = this.createLogFrame();
        }
        return this.logFrame;
    }

    protected OptionPanel createOptionPanel() {
        OptionPanel result = new OptionPanel();
        result.setTitle(TITLE_OPTION);
        result.pack();
        result.setSize(450, 500);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public OptionPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = this.createOptionPanel();
        }
        return this.optionPanel;
    }

    protected FindPanel createFindPanel() {
        FindPanel result = new FindPanel();
        result.setTitle(TITLE_FIND);
        result.pack();
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public FindPanel getFindPanel() {
        if (this.findPanel == null) {
            this.findPanel = this.createFindPanel();
        }
        return this.findPanel;
    }

    protected VillageDigest createVillageDigest() {
        VillageDigest result = new VillageDigest();
        result.setTitle(TITLE_DIGEST);
        result.pack();
        result.setSize(600, 550);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public VillageDigest getVillageDigest() {
        if (this.villageDigest == null) {
            this.villageDigest = this.createVillageDigest();
        }
        return this.villageDigest;
    }

    protected DaySummary createDaySummary() {
        DaySummary result = new DaySummary();
        result.setTitle(TITLE_DAYSUMMARY);
        result.pack();
        result.setSize(400, 500);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public DaySummary getDaySummary() {
        if (this.daySummary == null) {
            this.daySummary = this.createDaySummary();
        }
        return this.daySummary;
    }

    protected HelpFrame createHelpFrame() {
        HelpFrame result = new HelpFrame();
        result.setTitle(TITLE_HELP);
        result.pack();
        result.setSize(450, 450);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public HelpFrame getHelpFrame() {
        if (this.helpFrame == null) {
            this.helpFrame = this.createHelpFrame();
        }
        return this.helpFrame;
    }

    public TopFrame getTopFrame() {
        return this.topFrame;
    }

    public void changeAllWindowUI(String className) throws ReflectiveOperationException, UnsupportedLookAndFeelException {
        assert (EventQueue.isDispatchThread());
        UIManager.setLookAndFeel(className);
        this.windowSet.forEach(window -> SwingUtilities.updateComponentTreeUI(window));
        if (this.filterPanel != null) {
            this.filterPanel.pack();
        }
        if (this.findPanel != null) {
            this.findPanel.pack();
        }
    }
}

