/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.JsonSource;
import jp.sourceforge.jovsonz.ValueVisitor;

public final class JsBoolean
implements JsValue,
Comparable<JsBoolean> {
    public static final JsBoolean TRUE = new JsBoolean();
    public static final JsBoolean FALSE = new JsBoolean();
    public static final String TEXT_TRUE = "true";
    public static final String TEXT_FALSE = "false";
    public static final int HASH_TRUE = Boolean.TRUE.hashCode();
    public static final int HASH_FALSE = Boolean.FALSE.hashCode();

    private JsBoolean() {
    }

    static JsBoolean parseBoolean(JsonSource source) throws IOException, JsParseException {
        JsBoolean result = null;
        boolean hasError = false;
        char charHead = source.readOrDie();
        switch (charHead) {
            case 't': {
                if (source.matchOrDie("rue")) {
                    result = TRUE;
                    break;
                }
                hasError = true;
                break;
            }
            case 'f': {
                if (source.matchOrDie("alse")) {
                    result = FALSE;
                    break;
                }
                hasError = true;
                break;
            }
            default: {
                source.unread(charHead);
            }
        }
        if (hasError) {
            throw new JsParseException("invalid JSON token", source.getLineNumber());
        }
        return result;
    }

    @Override
    public JsTypes getJsTypes() {
        return JsTypes.BOOLEAN;
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
    }

    public int hashCode() {
        int result = this == TRUE ? HASH_TRUE : HASH_FALSE;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JsBoolean) {
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(JsBoolean value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException();
        }
        int result = this == value ? 0 : (this == TRUE ? -1 : 1);
        return result;
    }

    public static JsBoolean valueOf(boolean bool) {
        if (bool) {
            return TRUE;
        }
        return FALSE;
    }

    public boolean booleanValue() {
        return this == TRUE;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this != TRUE;
    }

    public String toString() {
        if (this == TRUE) {
            return TEXT_TRUE;
        }
        return TEXT_FALSE;
    }
}

